/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayException;
import com.avsystem.anjay.AnjayServerObject;
import com.avsystem.anjay.impl.NativeAnjay;
import com.avsystem.anjay.impl.NativeUtils;
import java.io.InputStream;
import java.io.OutputStream;

public final class NativeServerObject {
    private long self;

    private native void init(NativeAnjay var1);

    private native void cleanup();

    private native int anjayServerObjectAddInstance(AnjayServerObject.Instance var1, int var2);

    private native void anjayServerObjectPurge();

    private native int anjayServerObjectPersist(OutputStream var1);

    private native int anjayServerObjectRestore(InputStream var1);

    private native boolean anjayServerObjectIsModified();

    public NativeServerObject(Anjay anjay) throws Exception {
        this.init(NativeUtils.getNativeAnjay(anjay));
    }

    public int addInstance(AnjayServerObject.Instance instance, int preferredIid) {
        int result = this.anjayServerObjectAddInstance(instance, preferredIid);
        if (result < 0) {
            throw new AnjayException(result, "anjay_server_add_instance() failed");
        }
        return result;
    }

    public void purge() {
        this.anjayServerObjectPurge();
    }

    public void persist(OutputStream output_stream) {
        int result = this.anjayServerObjectPersist(output_stream);
        if (result < 0) {
            throw new AnjayException(result, "failed to persist Server object");
        }
    }

    public void restore(InputStream input_stream) {
        int result = this.anjayServerObjectRestore(input_stream);
        if (result < 0) {
            throw new AnjayException(result, "failed to restore Server object");
        }
    }

    public boolean isModified() {
        return this.anjayServerObjectIsModified();
    }
}

