/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.impl.NativeAnjay;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.time.Duration;

public final class NativeUtils {
    public static NativeAnjay getNativeAnjay(Anjay anjay) throws Exception {
        Field nativeAnjayField = Anjay.class.getDeclaredField("anjay");
        nativeAnjayField.setAccessible(true);
        NativeAnjay nativeAnjay = (NativeAnjay)nativeAnjayField.get(anjay);
        nativeAnjay.ensureValidState();
        return nativeAnjay;
    }

    public static ReadyState waitUntilReady(SelectableChannel channel, Duration timeout, ReadyState waitStates) throws IOException {
        try (Selector selector = Selector.open();){
            long remainingMs;
            int readySockets;
            int waitMask = 0;
            if (waitStates.read) {
                waitMask |= 1;
            }
            if (waitStates.write) {
                waitMask |= 4;
            }
            if (waitStates.connect) {
                waitMask |= 8;
            }
            if (waitStates.accept) {
                waitMask |= 0x10;
            }
            SelectionKey key = channel.register(selector, waitMask);
            long deadlineNs = System.nanoTime() + timeout.toNanos();
            while ((readySockets = (remainingMs = (deadlineNs - System.nanoTime()) / 1000000L) <= 0L ? selector.selectNow() : selector.select(remainingMs)) == 0 && remainingMs > 0L) {
            }
            ReadyState result = new ReadyState();
            if (selector.selectedKeys().contains(key)) {
                result.read = key.isReadable();
                result.write = key.isWritable();
                result.connect = key.isConnectable();
                result.accept = key.isAcceptable();
            }
            ReadyState readyState = result;
            return readyState;
        }
    }

    public static class ReadyState {
        public boolean read;
        public boolean write;
        public boolean connect;
        public boolean accept;

        public ReadyState(boolean read, boolean write, boolean connect, boolean accept) {
            this.read = read;
            this.write = write;
            this.connect = connect;
            this.accept = accept;
        }

        public ReadyState() {
            this(false, false, false, false);
        }
    }
}

