/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.model.system.ClientConfiguration;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfigurationFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientConfigurationFactory.class);
    public static final String DEFAULT_PROTOCOL = "http";
    public static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    public static final int DEFAULT_READ_TIMEOUT_MS = 1000;
    public static final String DEFAULT_CLIENT_PROPERTIES_FILE_NAME = "/client.properties";
    public static final String AXIBASE_TSD_API_DOMAIN = "axibase.tsd.api";
    public static final String DEFAULT_API_PATH = "/api/v1";
    private String serverName;
    private String serverPort;
    private String username;
    private String password;
    private String metadataPath;
    private String dataPath;
    private String protocol;
    private int connectTimeout;
    private int readTimeout;

    private ClientConfigurationFactory() {
    }

    public static ClientConfigurationFactory getInstance() {
        String defaultClientPropertiesFileName = DEFAULT_CLIENT_PROPERTIES_FILE_NAME;
        String sysPropertiesFileName = System.getProperty("axibase.tsd.api.client.properties");
        if (StringUtils.isNotBlank((CharSequence)sysPropertiesFileName)) {
            defaultClientPropertiesFileName = sysPropertiesFileName;
        }
        return ClientConfigurationFactory.getInstance(defaultClientPropertiesFileName);
    }

    public static ClientConfigurationFactory getInstance(String clientPropertiesFileName) {
        log.debug("Load client properties from file: {}", (Object)clientPropertiesFileName);
        Properties clientProperties = new Properties();
        try {
            InputStream stream = ClientConfigurationFactory.class.getResourceAsStream(clientPropertiesFileName);
            clientProperties.load(stream);
            IOUtils.closeQuietly((InputStream)stream);
        }
        catch (Throwable e) {
            log.warn("Could not load client properties", e);
        }
        ClientConfigurationFactory configurationFactory = new ClientConfigurationFactory();
        configurationFactory.serverName = ClientConfigurationFactory.load("axibase.tsd.api.server.name", clientProperties, null);
        configurationFactory.serverPort = ClientConfigurationFactory.load("axibase.tsd.api.server.port", clientProperties, null);
        configurationFactory.username = ClientConfigurationFactory.load("axibase.tsd.api.username", clientProperties, null);
        configurationFactory.password = ClientConfigurationFactory.load("axibase.tsd.api.password", clientProperties, null);
        configurationFactory.metadataPath = ClientConfigurationFactory.load("axibase.tsd.api.metadata.path", clientProperties, DEFAULT_API_PATH);
        configurationFactory.dataPath = ClientConfigurationFactory.load("axibase.tsd.api.data.path", clientProperties, DEFAULT_API_PATH);
        configurationFactory.protocol = ClientConfigurationFactory.load("axibase.tsd.api.protocol", clientProperties, DEFAULT_PROTOCOL);
        configurationFactory.connectTimeout = ClientConfigurationFactory.loadInt("axibase.tsd.api.connection.timeout", clientProperties, 1000);
        configurationFactory.readTimeout = ClientConfigurationFactory.loadInt("axibase.tsd.api.read.timeout", clientProperties, 1000);
        return configurationFactory;
    }

    public ClientConfiguration createClientConfiguration() {
        ClientConfiguration clientConfiguration = new ClientConfiguration(this.buildMetaDataUrl(), this.buildTimeSeriesUrl(), this.username, this.password);
        clientConfiguration.setConnectTimeout(this.connectTimeout);
        clientConfiguration.setReadTimeout(this.readTimeout);
        return clientConfiguration;
    }

    private String buildMetaDataUrl() {
        return this.protocol + "://" + this.serverName + ":" + this.serverPort + this.metadataPath;
    }

    private String buildTimeSeriesUrl() {
        return this.protocol + "://" + this.serverName + ":" + this.serverPort + this.dataPath;
    }

    private static int loadInt(String name, Properties clientProperties, int defaultValue) {
        return NumberUtils.toInt((String)ClientConfigurationFactory.load(name, clientProperties, ""), (int)defaultValue);
    }

    private static String load(String name, Properties clientProperties, String defaultValue) {
        String value = System.getProperty(name);
        if (value == null && (value = clientProperties.getProperty(name)) == null) {
            if (defaultValue == null) {
                log.error("Could not find required property: {}", (Object)name);
                throw new IllegalStateException(name + " property is null");
            }
            value = defaultValue;
        }
        return value;
    }
}

