/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.HttpClientManager;
import com.axibase.tsd.client.RequestProcessor;
import com.axibase.tsd.model.data.Alert;
import com.axibase.tsd.model.data.AlertHistory;
import com.axibase.tsd.model.data.GetSeriesResult;
import com.axibase.tsd.model.data.Interval;
import com.axibase.tsd.model.data.Property;
import com.axibase.tsd.model.data.Severity;
import com.axibase.tsd.model.data.command.AddSeriesCommand;
import com.axibase.tsd.model.data.command.GetAlertHistoryCommand;
import com.axibase.tsd.model.data.command.GetPropertiesCommand;
import com.axibase.tsd.model.data.command.GetSeriesCommand;
import com.axibase.tsd.model.data.command.PatchPropertiesCommand;
import com.axibase.tsd.query.Query;
import com.axibase.tsd.query.QueryPart;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Arrays;
import java.util.List;

public class DataService {
    private HttpClientManager httpClientManager;

    public DataService() {
    }

    public DataService(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public void setHttpClientManager(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public List<GetSeriesResult> retrieveSeries(Long startTime, Long endTime, Integer limit, GetSeriesCommand ... seriesQueries) {
        QueryPart query = new Query("series").param("json", "true").param("startTime", startTime).param("endTime", endTime).param("limit", limit);
        return this.httpClientManager.requestDataList(GetSeriesResult.class, query, RequestProcessor.post(seriesQueries));
    }

    public List<GetSeriesResult> retrieveSeries(Interval interval, Integer limit, GetSeriesCommand ... seriesQueries) {
        QueryPart query = new Query("series").param("json", "true").param("interval", interval).param("limit", limit);
        return this.httpClientManager.requestDataList(GetSeriesResult.class, query, RequestProcessor.post(seriesQueries));
    }

    public boolean addSeries(AddSeriesCommand ... addSeriesCommands) {
        QueryPart query = new Query("series").path("insert");
        return this.httpClientManager.updateData(query, RequestProcessor.post(Arrays.asList(addSeriesCommands)));
    }

    public boolean addSeriesCsv(String entityName, String data, String ... tagNamesAndValues) {
        AtsdUtil.check(entityName, "Entity name is empty");
        AtsdUtil.check(data, "Data is empty");
        QueryPart query = new Query("series").path("csv").path(entityName);
        if (tagNamesAndValues != null) {
            if (tagNamesAndValues.length % 2 == 1) {
                throw new IllegalArgumentException("Tag without value");
            }
            for (int i = 0; i < tagNamesAndValues.length; ++i) {
                query = query.param(tagNamesAndValues[i], tagNamesAndValues[++i]);
            }
        }
        return this.httpClientManager.updateData(query, data);
    }

    public List<GetSeriesResult> retrieveLastSeries(GetSeriesCommand ... seriesQueries) {
        QueryPart query = new Query("series").path("last");
        return this.httpClientManager.requestDataList(GetSeriesResult.class, query, RequestProcessor.post(seriesQueries));
    }

    public List<Property> retrieveProperties(GetPropertiesCommand getPropertiesCommand) {
        Query query = new Query("properties");
        return this.httpClientManager.requestDataList(Property.class, query, RequestProcessor.post(getPropertiesCommand));
    }

    public boolean insertProperties(PatchPropertiesCommand patchPropertiesCommand) {
        QueryPart query = new Query("properties").path("insert");
        return this.httpClientManager.updateData(query, RequestProcessor.post(patchPropertiesCommand));
    }

    public List<Alert> retrieveAlerts(List<String> metricNames, List<String> entityNames, List<String> ruleNames, List<Severity> severities, Severity minSeverity) {
        QueryPart<Alert> query = new Query<Alert>("/alerts");
        if (minSeverity != null) {
            query.param("min-severity", minSeverity.getCode());
        }
        query = this.fillParams(query, "metric", metricNames);
        query = this.fillParams(query, "entity", entityNames);
        query = this.fillParams(query, "rule", ruleNames);
        if (severities != null) {
            for (Severity severity : severities) {
                query = query.param("severity", severity.getCode());
            }
        }
        return this.httpClientManager.requestDataList(Alert.class, query, null);
    }

    public List<AlertHistory> retrieveAlertHistory(GetAlertHistoryCommand getAlertHistoryCommand) {
        QueryPart query = new Query("alerts").path("history");
        return this.httpClientManager.requestDataList(AlertHistory.class, query, RequestProcessor.post(getAlertHistoryCommand));
    }

    public QueryPart<Alert> fillParams(QueryPart<Alert> query, String paramName, List<String> paramValueList) {
        if (paramValueList != null) {
            for (String paramValue : paramValueList) {
                query = query.param(paramName, paramValue);
            }
        }
        return query;
    }
}

