/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.command;

import com.axibase.tsd.model.data.Series;
import com.axibase.tsd.util.AtsdUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AddSeriesCommand {
    @JsonProperty(value="entity")
    private String entityName;
    @JsonProperty(value="metric")
    private String metricName;
    private Map<String, String> tags;
    private List<Series> data;

    public AddSeriesCommand() {
    }

    public AddSeriesCommand(String entityName, String metricName, String ... tagNamesAndValues) {
        this.entityName = entityName;
        this.metricName = metricName;
        this.tags = AtsdUtil.toMap(tagNamesAndValues);
    }

    public static AddSeriesCommand createSingle(String entityName, String metricName, long time, double value, String ... tagNamesAndValues) {
        AddSeriesCommand addSeriesCommand = new AddSeriesCommand(entityName, metricName, tagNamesAndValues);
        addSeriesCommand.addSeries(new Series(time, value));
        return addSeriesCommand;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public List<Series> getData() {
        return this.data;
    }

    public void addSeries(Series series) {
        if (this.data == null) {
            this.data = new ArrayList<Series>();
        }
        this.data.add(series);
    }

    public void addSeries(Series ... series) {
        if (this.data == null) {
            this.data = new ArrayList<Series>();
        }
        this.data.addAll(Arrays.asList(series));
    }
}

