/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.client.HttpClient;
import com.axibase.tsd.client.PlainSender;
import com.axibase.tsd.client.RequestProcessor;
import com.axibase.tsd.model.system.ClientConfiguration;
import com.axibase.tsd.plain.PlainCommand;
import com.axibase.tsd.query.QueryPart;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientManager {
    private static final Logger log = LoggerFactory.getLogger(HttpClientManager.class);
    private static final int DEFAULT_BORROW_MAX_TIME_MS = 3000;
    private static final int DEFAULT_PING_PERIOD_MS = 5000;
    private static final int DEFAULT_MAX_TOTAL = 100;
    private static final int DEFAULT_MAX_IDLE = 100;
    private ClientConfiguration clientConfiguration;
    private GenericObjectPoolConfig objectPoolConfig;
    private AtomicReference<GenericObjectPool<HttpClient>> objectPoolAtomicReference = new AtomicReference();
    private int borrowMaxWaitMillis = 3000;
    private long pingPeriodMillis = 5000L;
    private final AtomicReference<PlainSender> plainSender = new AtomicReference();
    private final AtomicLong lastPingTime = new AtomicLong(0L);
    private final List<PlainCommand> saved = new ArrayList<PlainCommand>();
    private boolean lastPingResult = true;

    public HttpClientManager() {
        this.objectPoolConfig = new GenericObjectPoolConfig();
        this.objectPoolConfig.setMaxTotal(100);
        this.objectPoolConfig.setMaxIdle(100);
    }

    public HttpClientManager(ClientConfiguration clientConfiguration) {
        this();
        this.clientConfiguration = clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public void setObjectPoolConfig(GenericObjectPoolConfig objectPoolConfig) {
        this.objectPoolConfig = objectPoolConfig;
    }

    public void setBorrowMaxWaitMillis(int borrowMaxWaitMillis) {
        this.borrowMaxWaitMillis = borrowMaxWaitMillis;
    }

    public void setPingPeriodMillis(long pingPeriodMillis) {
        this.pingPeriodMillis = pingPeriodMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> requestMetaDataList(Class<T> clazz, QueryPart<T> query) {
        HttpClient httpClient = this.borrowClient();
        try {
            List<T> list = httpClient.requestMetaDataList(clazz, query);
            return list;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T requestMetaDataObject(Class<T> clazz, QueryPart<T> query) {
        HttpClient httpClient = this.borrowClient();
        try {
            T t = httpClient.requestMetaDataObject(clazz, query);
            return t;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> boolean updateMetaData(QueryPart query, RequestProcessor<E> requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            boolean bl = httpClient.updateMetaData(query, requestProcessor);
            return bl;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateData(QueryPart query, RequestProcessor requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            boolean bl = httpClient.updateData(query, requestProcessor);
            return bl;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateData(QueryPart query, String data) {
        HttpClient httpClient = this.borrowClient();
        try {
            boolean bl = httpClient.updateData(query, data);
            return bl;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E> List<T> requestDataList(Class<T> clazz, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            List<T> list = httpClient.requestDataList(clazz, query, requestProcessor);
            return list;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E> T requestData(Class<T> clazz, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            T t = httpClient.requestData(clazz, query, requestProcessor);
            return t;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    private HttpClient borrowClient() {
        HttpClient httpClient;
        GenericObjectPool<HttpClient> objectPool = this.createObjectPool();
        try {
            httpClient = (HttpClient)objectPool.borrowObject((long)this.borrowMaxWaitMillis);
        }
        catch (Exception e) {
            throw new AtsdClientException("Could not borrow http client from pool", e);
        }
        return httpClient;
    }

    private void returnClient(HttpClient httpClient) {
        this.objectPoolAtomicReference.get().returnObject((Object)httpClient);
    }

    private GenericObjectPool<HttpClient> createObjectPool() {
        GenericObjectPool httpClientGenericObjectPool = this.objectPoolAtomicReference.get();
        if (httpClientGenericObjectPool == null) {
            httpClientGenericObjectPool = new GenericObjectPool((PooledObjectFactory)new HttpClientBasePooledObjectFactory(), this.objectPoolConfig);
            this.objectPoolAtomicReference.compareAndSet(null, (GenericObjectPool<HttpClient>)httpClientGenericObjectPool);
        }
        return this.objectPoolAtomicReference.get();
    }

    public void close() {
        PlainSender sender;
        GenericObjectPool<HttpClient> pool = this.objectPoolAtomicReference.get();
        if (pool != null) {
            pool.close();
        }
        if ((sender = this.plainSender.get()) != null) {
            sender.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(PlainCommand plainCommand) {
        if (!this.lastPingResult) {
            throw new IllegalStateException("Last ping was bad");
        }
        PlainSender sender = this.prepareSender();
        if (this.canSendPlainCommand()) {
            try {
                sender.send(plainCommand);
            }
            finally {
                this.saved.add(plainCommand);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ping() {
        String dataUrl = this.clientConfiguration.getDataUrl();
        Socket socket = null;
        String host = null;
        int port = -1;
        try {
            URI uri = new URI(dataUrl);
            host = uri.getHost();
            port = uri.getPort();
            socket = new Socket(host, port);
            if (socket == null) return true;
        }
        catch (Throwable e) {
            try {
                log.info("Ping (host={}, port={}) error: ", new Object[]{host, port, e});
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e2) {}
                }
            }
        }
        try {
            socket.close();
            return true;
        }
        catch (IOException e) {
            return true;
        }
    }

    private PlainSender prepareSender() {
        PlainSender sender = this.plainSender.get();
        if (sender == null || !sender.isCorrect()) {
            PlainSender newSender = new PlainSender(this.clientConfiguration, sender);
            if (this.plainSender.compareAndSet(sender, newSender)) {
                Executors.newSingleThreadExecutor().execute(newSender);
            }
            sender = this.plainSender.get();
        }
        return sender;
    }

    public boolean canSendPlainCommand() {
        long last = this.lastPingTime.get();
        long current = System.currentTimeMillis();
        if (current - last > this.pingPeriodMillis && this.lastPingTime.compareAndSet(last, current)) {
            boolean pingResult = this.lastPingResult;
            this.lastPingResult = this.ping();
            if (pingResult && this.lastPingResult) {
                this.saved.clear();
            }
        }
        return this.lastPingResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PlainCommand> removeSavedPlainCommands() {
        if (this.saved.isEmpty()) {
            return Collections.emptyList();
        }
        List<PlainCommand> list = this.saved;
        synchronized (list) {
            ArrayList<PlainCommand> result = new ArrayList<PlainCommand>(this.saved);
            this.saved.removeAll(result);
            if (result.size() > 0) {
                log.info("{} commands are removed from saved list", (Object)result.size());
            }
            return result;
        }
    }

    private class HttpClientBasePooledObjectFactory
    extends BasePooledObjectFactory<HttpClient> {
        private HttpClientBasePooledObjectFactory() {
        }

        public HttpClient create() throws Exception {
            return new HttpClient(HttpClientManager.this.clientConfiguration);
        }

        public PooledObject<HttpClient> wrap(HttpClient httpClient) {
            return new DefaultPooledObject((Object)httpClient);
        }

        public void destroyObject(PooledObject<HttpClient> p) throws Exception {
            ((HttpClient)p.getObject()).close();
        }
    }
}

