/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.HttpClient;
import com.axibase.tsd.model.system.ClientConfiguration;
import com.axibase.tsd.plain.MarkerCommand;
import com.axibase.tsd.plain.PlainCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.SslConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlainSender
extends AbstractHttpEntity
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PlainSender.class);
    private static final String PING_COMMAND = "ping\n";
    private static final int SMALL = 64;
    private String url;
    private CountDownLatch latch = new CountDownLatch(1);
    private CloseableHttpClient httpClient;
    private BlockingQueue<String> messages;
    private Map<String, List<String>> markerToMessages = new LinkedHashMap<String, List<String>>();
    private volatile boolean closed = false;
    private volatile boolean active;
    private volatile boolean correct = false;
    private final long pingTimeoutMillis;
    private long lastMessageTime;
    private CloseableHttpResponse response;
    private final ClientConfiguration clientConfiguration;
    private PoolingHttpClientConnectionManager connectionManager;

    public PlainSender(ClientConfiguration clientConfiguration, PlainSender old) {
        this.clientConfiguration = clientConfiguration;
        this.url = clientConfiguration.getDataUrl();
        this.pingTimeoutMillis = clientConfiguration.getPingTimeoutMillis();
        if (old != null) {
            this.messages = old.messages;
            log.info("Reborn plain commands sender using previous messages, size: {}", (Object)this.messages.size());
        }
    }

    public void send(PlainCommand plainCommand) {
        if (!this.correct) {
            throw new IllegalStateException("Could not send command using incorrect sender");
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            log.error("Initialization error:", (Throwable)e);
        }
        String text = plainCommand.compose();
        if (StringUtils.isBlank((CharSequence)text)) {
            log.error("Command is empty");
            return;
        }
        if (!text.endsWith("\n")) {
            text = text + "\n";
        }
        this.messages.add(text);
        log.debug("Message is added to queue, queue size = {}", (Object)(this.messages == null ? 0 : this.messages.size()));
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        String marker = null;
        while (this.active) {
            String message = null;
            try {
                message = this.messages.poll(this.pingTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.error("Could not poll message from queue", (Throwable)e);
            }
            try {
                if (message != null) {
                    if (marker == null && !message.startsWith("marker ")) {
                        MarkerCommand markerCommand = new MarkerCommand();
                        marker = markerCommand.getMarker();
                        this.write(outputStream, markerCommand.compose());
                    }
                    log.debug("Write message: {}", (Object)message);
                    this.write(outputStream, message);
                    if (message.startsWith("marker ")) {
                        marker = StringUtils.removeStart((String)message, (String)"marker ").trim();
                        if (StringUtils.isBlank((CharSequence)marker)) {
                            throw new IllegalArgumentException("Bad marker message: " + message);
                        }
                    } else {
                        this.add(marker, message);
                    }
                    this.lastMessageTime = System.currentTimeMillis();
                }
            }
            catch (Throwable e) {
                this.active = false;
                this.correct = false;
                log.error("Sender is died. Could not send message: {}", (Object)message, (Object)e);
                this.messages.add(message);
                this.close();
                return;
            }
            if (this.lastMessageTime - System.currentTimeMillis() <= this.pingTimeoutMillis) continue;
            this.write(outputStream, PING_COMMAND);
            this.add(marker, PING_COMMAND);
            this.lastMessageTime = System.currentTimeMillis();
        }
    }

    private void write(OutputStream outputStream, String text) throws IOException {
        outputStream.write(text.getBytes());
        outputStream.flush();
    }

    private void add(String marker, String message) {
        List<String> stored = this.markerToMessages.get(marker);
        if (stored == null) {
            stored = new ArrayList<String>();
            this.markerToMessages.put(marker, stored);
        }
        stored.add(message);
    }

    public boolean isStreaming() {
        return true;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.active = false;
        this.correct = false;
        if (this.response != null) {
            try {
                this.response.close();
            }
            catch (IOException e) {
                log.error("Could not close response: {}", (Object)this.response, (Object)e);
            }
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.error("Could not close client: {}", (Object)this.httpClient, (Object)e);
            }
        }
        if (this.connectionManager != null) {
            this.connectionManager.close();
        }
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.messages == null) {
            this.messages = new LinkedBlockingQueue<String>();
        }
        this.latch.countDown();
        SslConfigurator sslConfig = SslConfigurator.newInstance().securityProtocol("SSL");
        this.connectionManager = HttpClient.createConnectionManager(this.clientConfiguration, sslConfig);
        this.connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(64).build());
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager).build();
        HttpPost httpPost = new HttpPost(this.url + "/command");
        httpPost.setHeader("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])(this.clientConfiguration.getUsername() + ":" + this.clientConfiguration.getPassword()).getBytes()));
        httpPost.setEntity((HttpEntity)this);
        try {
            this.active = true;
            this.response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Throwable e) {
            log.error("Could not execute HTTP POST: {}", (Object)httpPost, (Object)e);
        }
        finally {
            this.correct = false;
            this.active = false;
        }
    }

    public boolean isCorrect() {
        return this.correct;
    }

    Map<String, List<String>> getMarkerToMessages() {
        return this.markerToMessages;
    }

    void setCorrect(boolean correct) {
        this.correct = correct;
    }
}

