/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.client.AtsdServerException;
import com.axibase.tsd.client.HttpClientManager;
import com.axibase.tsd.client.RequestProcessor;
import com.axibase.tsd.client.SeriesCommandPreparer;
import com.axibase.tsd.model.data.Alert;
import com.axibase.tsd.model.data.AlertHistory;
import com.axibase.tsd.model.data.Property;
import com.axibase.tsd.model.data.TimeFormat;
import com.axibase.tsd.model.data.command.AddSeriesCommand;
import com.axibase.tsd.model.data.command.BatchAlertCommand;
import com.axibase.tsd.model.data.command.BatchPropertyCommand;
import com.axibase.tsd.model.data.command.BatchQuery;
import com.axibase.tsd.model.data.command.GetAlertHistoryQuery;
import com.axibase.tsd.model.data.command.GetAlertQuery;
import com.axibase.tsd.model.data.command.GetPropertiesQuery;
import com.axibase.tsd.model.data.command.GetSeriesQuery;
import com.axibase.tsd.model.data.series.GetSeriesBatchResult;
import com.axibase.tsd.model.data.series.GetSeriesResult;
import com.axibase.tsd.model.data.series.aggregate.AggregateType;
import com.axibase.tsd.model.system.Format;
import com.axibase.tsd.plain.PlainCommand;
import com.axibase.tsd.query.Query;
import com.axibase.tsd.query.QueryPart;
import com.axibase.tsd.util.AtsdUtil;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DataService {
    public static final SeriesCommandPreparer LAST_PREPARER = new LastPreparer();
    private HttpClientManager httpClientManager;

    public DataService() {
    }

    public DataService(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public void setHttpClientManager(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public List<GetSeriesResult> retrieveSeries(GetSeriesQuery ... seriesQueries) {
        Query query = new Query("series");
        GetSeriesBatchResult seriesBatchResult = this.httpClientManager.requestData(GetSeriesBatchResult.class, query, RequestProcessor.post(new BatchQuery<GetSeriesQuery>(Arrays.asList(seriesQueries))));
        return seriesBatchResult == null ? Collections.emptyList() : seriesBatchResult.getSeriesResults();
    }

    public List<GetSeriesResult> retrieveSeries(SeriesCommandPreparer preparer, GetSeriesQuery ... seriesQueries) {
        if (preparer != null) {
            for (GetSeriesQuery seriesQuery : seriesQueries) {
                preparer.prepare(seriesQuery);
            }
        }
        return this.retrieveSeries(seriesQueries);
    }

    public boolean addSeries(AddSeriesCommand ... addSeriesCommands) {
        QueryPart query = new Query("series").path("insert");
        return this.httpClientManager.updateData(query, RequestProcessor.post(Arrays.asList(addSeriesCommands)));
    }

    public boolean addSeriesCsv(String entityName, String data, String ... tagNamesAndValues) {
        AtsdUtil.checkEntityName(entityName);
        AtsdUtil.check(data, "Data is empty");
        QueryPart query = new Query("series").path("csv").path(entityName);
        if (tagNamesAndValues != null) {
            if (tagNamesAndValues.length % 2 == 1) {
                throw new IllegalArgumentException("Tag without value");
            }
            for (int i = 0; i < tagNamesAndValues.length; ++i) {
                query = query.param(tagNamesAndValues[i], tagNamesAndValues[++i]);
            }
        }
        return this.httpClientManager.updateData(query, data);
    }

    public List<GetSeriesResult> retrieveLastSeries(GetSeriesQuery ... seriesQueries) {
        return this.retrieveSeries(LAST_PREPARER, seriesQueries);
    }

    public InputStream querySeriesPack(Format format, String entityName, String metricName, Map<String, String> tags, long startTime, long endTime, String period, AggregateType aggregateType, Integer limit, Boolean last, String columns) {
        QueryPart seriesQuery = new Query("series").path(format.name().toLowerCase()).path(entityName).path(metricName).param("startTime", startTime).param("endTime", endTime).param("period", period).param("aggregate", aggregateType == null ? null : aggregateType.name().toLowerCase()).param("limit", limit).param("last", last).param("columns", columns);
        for (Map.Entry<String, String> tagAndValue : tags.entrySet()) {
            seriesQuery = seriesQuery.param("t:" + tagAndValue.getKey(), tagAndValue.getValue());
        }
        return this.httpClientManager.requestInputStream(seriesQuery, null);
    }

    public List<Property> retrieveProperties(GetPropertiesQuery getPropertiesQuery, GetPropertiesQuery ... getPropertiesQueries) {
        Query query = new Query("properties");
        return this.httpClientManager.requestDataList(Property.class, query, RequestProcessor.post(new BatchQuery<GetPropertiesQuery>(getPropertiesQuery, getPropertiesQueries)));
    }

    public List<Property> retrieveProperties(String entityName, String typeName) {
        AtsdUtil.checkEntityName(entityName);
        AtsdUtil.check(typeName, "Property type name is empty");
        QueryPart query = new Query("properties");
        query = query.path(entityName).path("types").path(typeName);
        return this.httpClientManager.requestDataList(Property.class, query, null);
    }

    public boolean insertProperties(Property ... properties) {
        QueryPart query = new Query("properties").path("insert");
        return this.httpClientManager.updateData(query, RequestProcessor.post(Arrays.asList(properties)));
    }

    public boolean batchUpdateProperties(BatchPropertyCommand ... batchPropertyCommands) {
        Query query = new Query("properties");
        return this.httpClientManager.updateData(query, RequestProcessor.patch(batchPropertyCommands));
    }

    public List<Alert> retrieveAlerts(List<String> metricNames, List<String> entityNames, List<String> ruleNames, List<Integer> severityIds, Integer minSeverityId, TimeFormat timeFormat) {
        GetAlertQuery alertQuery = new GetAlertQuery(metricNames, entityNames, ruleNames, severityIds, minSeverityId, timeFormat);
        return this.retrieveAlerts(alertQuery, new GetAlertQuery[0]);
    }

    public List<Alert> retrieveAlerts(GetAlertQuery alertQuery, GetAlertQuery ... alertQueries) {
        Query query = new Query("/alerts");
        BatchQuery<GetAlertQuery> batchQuery = new BatchQuery<GetAlertQuery>(alertQuery, alertQueries);
        return this.httpClientManager.requestDataList(Alert.class, query, RequestProcessor.post(batchQuery));
    }

    public List<AlertHistory> retrieveAlertHistory(GetAlertHistoryQuery getAlertHistoryQuery, GetAlertHistoryQuery ... getAlertHistoryQueries) {
        QueryPart query = new Query("alerts").path("history");
        return this.httpClientManager.requestDataList(AlertHistory.class, query, RequestProcessor.post(new BatchQuery<GetAlertHistoryQuery>(getAlertHistoryQuery, getAlertHistoryQueries)));
    }

    public boolean batchUpdateAlerts(BatchAlertCommand ... commands) {
        Query query = new Query("alerts");
        return this.httpClientManager.updateData(query, RequestProcessor.patch(commands));
    }

    private static QueryPart<Alert> fillParams(QueryPart<Alert> query, String paramName, List<String> paramValueList) {
        if (paramValueList != null) {
            for (String paramValue : paramValueList) {
                query = query.param(paramName, paramValue);
            }
        }
        return query;
    }

    public void sendPlainCommand(PlainCommand plainCommand) throws AtsdClientException, AtsdServerException {
        this.httpClientManager.send(plainCommand);
    }

    public boolean canSendPlainCommand() {
        return this.httpClientManager.canSendPlainCommand();
    }

    public List<String> removeSavedPlainCommands() {
        return this.httpClientManager.removeSavedPlainCommands();
    }

    private static class LastPreparer
    implements SeriesCommandPreparer {
        private LastPreparer() {
        }

        @Override
        public void prepare(GetSeriesQuery command) {
            command.setLast(true);
        }
    }
}

