/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.plain;

import com.axibase.tsd.model.data.series.Series;
import com.axibase.tsd.plain.AbstractInsertCommand;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Collections;
import java.util.Map;

public class InsertCommand
extends AbstractInsertCommand {
    public static final String SERIES_COMMAND = "series";
    private final String metricName;
    private final Series series;

    public InsertCommand(String entityName, String metricName, Series series, Map<String, String> tags) {
        super(SERIES_COMMAND, entityName, series.getTimeMillis(), tags);
        AtsdUtil.checkMetricName(metricName);
        this.metricName = metricName;
        this.series = series;
    }

    public InsertCommand(String entityName, String metricName, Series series) {
        this(entityName, metricName, series, Collections.emptyMap());
    }

    public InsertCommand(String entityName, String metricName, Series series, String ... tagNamesAndValues) {
        this(entityName, metricName, series, AtsdUtil.toMap(tagNamesAndValues));
    }

    @Override
    protected void appendValues(StringBuilder sb) {
        sb.append(" m:").append(InsertCommand.clean(this.metricName)).append('=').append(this.series.getValue());
    }
}

