/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.command;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BatchAlertCommand {
    private final String action;
    private Fields fields;
    private final List<AlertId> alerts = new ArrayList<AlertId>();

    private BatchAlertCommand(String action, String[] alertIds) {
        this.action = action;
        for (int i = 0; i < alertIds.length; ++i) {
            String alertId = alertIds[i];
            this.alerts.add(new AlertId(alertId));
        }
    }

    public String getAction() {
        return this.action;
    }

    public Fields getFields() {
        return this.fields;
    }

    public List<AlertId> getAlerts() {
        return this.alerts;
    }

    public static BatchAlertCommand createUpdateCommand(boolean acknowledge, String ... alertIds) {
        BatchAlertCommand insertCommand = new BatchAlertCommand("update", alertIds);
        insertCommand.fields = new Fields(acknowledge);
        return insertCommand;
    }

    public static BatchAlertCommand createDeleteCommand(String ... alertIds) {
        BatchAlertCommand deleteCommand = new BatchAlertCommand("delete", alertIds);
        return deleteCommand;
    }

    public static class AlertId {
        private final String id;

        public AlertId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class Fields {
        private final boolean acknowledge;

        public Fields(boolean acknowledge) {
            this.acknowledge = acknowledge;
        }

        public boolean isAcknowledge() {
            return this.acknowledge;
        }
    }
}

