/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.command;

import com.axibase.tsd.model.data.Property;
import com.axibase.tsd.model.data.command.PropertyMatcher;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BatchPropertyCommand {
    private final String action;
    private List<Property> properties;
    private List<PropertyMatcher> matchers;

    private BatchPropertyCommand(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<PropertyMatcher> getMatchers() {
        return this.matchers;
    }

    public static BatchPropertyCommand createInsertCommand(Property ... properties) {
        BatchPropertyCommand insertCommand = new BatchPropertyCommand("insert");
        insertCommand.properties = Arrays.asList(properties);
        return insertCommand;
    }

    public static BatchPropertyCommand createDeleteCommand(Property ... properties) {
        BatchPropertyCommand deleteCommand = new BatchPropertyCommand("delete");
        deleteCommand.properties = Arrays.asList(properties);
        return deleteCommand;
    }

    public static BatchPropertyCommand createDeleteMatchCommand(PropertyMatcher ... propertyMatchers) {
        BatchPropertyCommand insertCommand = new BatchPropertyCommand("delete-match");
        insertCommand.matchers = Arrays.asList(propertyMatchers);
        return insertCommand;
    }
}

