/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.collector.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.FilterReply;
import com.axibase.collector.Aggregator;
import com.axibase.collector.Tag;
import com.axibase.collector.logback.LogbackMessageWriter;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;

public class Collector<E extends ILoggingEvent>
extends Filter<E>
implements ContextAware {
    private final LogbackMessageWriter<E> logbackMessageBuilder = new LogbackMessageWriter();
    private final Aggregator<E> aggregator = new Aggregator<E>(this.logbackMessageBuilder);
    private Level level = Level.TRACE;

    public FilterReply decide(E event) {
        try {
            if (event.getLevel().isGreaterOrEqual(this.level)) {
                this.aggregator.register(event);
            }
        }
        catch (IOException e) {
            this.addError("Could not write message", e);
        }
        return FilterReply.NEUTRAL;
    }

    public void start() {
        super.start();
        this.aggregator.start();
        this.logbackMessageBuilder.start();
    }

    public void stop() {
        super.stop();
        this.aggregator.stop();
        this.logbackMessageBuilder.stop();
    }

    public void setZeroRepeats(int zeroRepeats) {
        this.aggregator.setZeroRepeats(zeroRepeats);
        this.logbackMessageBuilder.setZeroRepeats(zeroRepeats);
    }

    public void setTag(Tag tag) {
        this.logbackMessageBuilder.addTag(tag);
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setWriter(WritableByteChannel writer) {
        this.aggregator.setWriter(writer);
    }

    public void setSendEvery(int sendEvery) {
        this.aggregator.setSendEvery(sendEvery);
    }

    public void setSendThreshold(int sendThreshold) {
        this.aggregator.setSendThreshold(sendThreshold);
    }

    public void setPeriodSec(int periodSec) {
        this.aggregator.setPeriodSec(periodSec);
    }

    public void setEntity(String entity) {
        this.logbackMessageBuilder.setEntity(entity);
    }

    public void setMetric(String metric) {
        this.logbackMessageBuilder.setMetric(metric);
    }
}

