/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.collector.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.axibase.collector.MessageWriter;
import com.axibase.collector.Tag;
import com.axibase.collector.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LogbackMessageWriter<E extends ILoggingEvent>
implements MessageWriter<E> {
    public static final String DEFAULT_METRIC_NAME = "log_event_count";
    public static final int DEFAULT_BB_SIZE = 16384;
    private Map<String, String> tags = new LinkedHashMap<String, String>();
    private int zeroRepeats;
    private String entity = Utils.resolveHostname();
    private String metric = "log_event_count";
    private Map<Key, Counter> story = new HashMap<Key, Counter>();
    private ByteBuffer seriesPrefix;
    private ByteBuffer messagePrefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStatMessages(WritableByteChannel writer, Collection<E> events) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(16384);
        for (Counter counter : this.story.values()) {
            counter.decrementZeroRepeats();
        }
        for (ILoggingEvent event : events) {
            Key key = new Key(event.getLevel(), event.getLoggerName());
            Counter counter = this.story.get(key);
            if (counter == null) {
                this.story.put(key, new Counter(this.zeroRepeats));
                continue;
            }
            counter.increment();
            counter.setZeroRepeats(this.zeroRepeats);
        }
        long time = System.currentTimeMillis();
        Iterator<Map.Entry<Key, Counter>> iterator = this.story.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Key, Counter> entry = iterator.next();
            Counter counter = entry.getValue();
            if (counter.zeroRepeats < 0) {
                iterator.remove();
                continue;
            }
            try {
                this.seriesPrefix.rewind();
                writer.write(this.seriesPrefix);
                StringBuilder sb = new StringBuilder();
                Key key = entry.getKey();
                Level level = key.level;
                String levelString = level.toString();
                sb.append(counter.value).append(" t:level=").append(levelString);
                sb.append(" t:logger=").append(Utils.sanitizeTagValue(key.logger));
                sb.append(" ms:").append(time).append("\n");
                writer.write(ByteBuffer.wrap(sb.toString().getBytes()));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                counter.value = 0;
            }
        }
    }

    @Override
    public void writeSingleMessage(WritableByteChannel writer, E event) throws IOException {
        this.messagePrefix.rewind();
        writer.write(this.messagePrefix);
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.sanitizeMessage(event.getFormattedMessage())).append(" t:level=").append(event.getLevel());
        sb.append(" t:logger=").append(Utils.sanitizeTagValue(event.getLoggerName()));
        sb.append(" ms:").append(System.currentTimeMillis()).append("\n");
        writer.write(ByteBuffer.wrap(sb.toString().getBytes()));
    }

    @Override
    public void start() {
        StringBuilder sb = new StringBuilder();
        sb.append("series e:").append(Utils.sanitizeEntity(this.entity));
        this.appendTags(sb);
        sb.append(" m:").append(Utils.sanitizeMetric(this.metric)).append("=");
        this.seriesPrefix = ByteBuffer.wrap(sb.toString().getBytes(Utils.UTF_8));
        sb = new StringBuilder();
        sb.append("message e:").append(Utils.sanitizeEntity(this.entity));
        this.appendTags(sb);
        sb.append(" m:");
        this.messagePrefix = ByteBuffer.wrap(sb.toString().getBytes(Utils.UTF_8));
    }

    private void appendTags(StringBuilder sb) {
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            sb.append(" t:").append(Utils.sanitizeTagKey(entry.getKey())).append("=").append(Utils.sanitizeTagValue(entry.getValue()));
        }
    }

    @Override
    public void stop() {
    }

    public void addTag(Tag tag) {
        this.tags.put(tag.getName(), tag.getValue());
    }

    public void setZeroRepeats(int zeroRepeats) {
        this.zeroRepeats = zeroRepeats;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    private static class Counter {
        private int zeroRepeats;
        private int value = 1;

        public Counter(int zeroRepeats) {
            this.zeroRepeats = zeroRepeats;
        }

        void increment() {
            ++this.value;
        }

        void decrementZeroRepeats() {
            --this.zeroRepeats;
        }

        public void setZeroRepeats(int zeroRepeats) {
            this.zeroRepeats = zeroRepeats;
        }
    }

    private static class Key {
        private final Level level;
        private final String logger;

        public Key(Level level, String logger) {
            if (level == null) {
                throw new IllegalArgumentException("Level is null");
            }
            this.level = level;
            this.logger = logger;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.level != null ? !this.level.equals(key.level) : key.level != null) {
                return false;
            }
            return !(this.logger == null ? key.logger != null : !this.logger.equals(key.logger));
        }

        public int hashCode() {
            int result = this.level != null ? this.level.hashCode() : 0;
            result = 31 * result + (this.logger != null ? this.logger.hashCode() : 0);
            return result;
        }
    }
}

