/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.collector.config;

public class SeriesSenderConfig {
    public static final String DEFAULT_METRIC_NAME = "log_event";
    public static final String DEFAULT_RATE_SUFFIX = "_rate";
    public static final String DEFAULT_TOTAL_SUFFIX = "_total";
    public static final String DEFAULT_COUNTER_SUFFIX = "_counter";
    public static final int DEFAULT_ZERO_REPEAT_COUNT = 1;
    public static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    public static final long DEFAULT_PERIOD_SECONDS = 60000L;
    public static final long DEFAULT_MIN_PERIOD_SECONDS = 5000L;
    public static final SeriesSenderConfig DEFAULT = new SeriesSenderConfig();
    private String metric = "log_event";
    private int zeroRepeatCount = 1;
    private long periodMs = 60000000L;
    private long minPeriodMs = 5000000L;
    private int sendThreshold;
    private long ratePeriodMs = 60000L;
    private String rateSuffix = "_rate";
    private String totalSuffix = "_total";
    private String counterSuffix = "_counter";

    public SeriesSenderConfig() {
    }

    public SeriesSenderConfig(int zeroRepeatCount, int periodSeconds, int sendThreshold) {
        this.zeroRepeatCount = zeroRepeatCount;
        this.sendThreshold = sendThreshold;
        this.setPeriodSeconds(periodSeconds);
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setZeroRepeatCount(int zeroRepeatCount) {
        this.zeroRepeatCount = zeroRepeatCount;
    }

    public void setPeriodSeconds(int periodSeconds) {
        if (periodSeconds < 1) {
            throw new IllegalArgumentException("Period value must by more than 0, currently " + periodSeconds);
        }
        this.periodMs = (long)periodSeconds * 1000L;
    }

    public void setMinPeriodSeconds(long minPeriodSeconds) {
        if (minPeriodSeconds < 0L) {
            throw new IllegalArgumentException("Min period value must by more than or equals 0, currently " + minPeriodSeconds);
        }
        this.minPeriodMs = minPeriodSeconds * 1000L;
    }

    public void setSendThreshold(int sendThreshold) {
        this.sendThreshold = sendThreshold;
    }

    public void setTotalSuffix(String totalSuffix) {
        this.totalSuffix = totalSuffix;
    }

    public String getMetric() {
        return this.metric;
    }

    public int getZeroRepeatCount() {
        return this.zeroRepeatCount;
    }

    public long getPeriodMs() {
        return this.periodMs;
    }

    public long getMinPeriodMs() {
        return this.minPeriodMs;
    }

    public int getSendThreshold() {
        return this.sendThreshold;
    }

    public String getTotalSuffix() {
        return this.totalSuffix;
    }

    public long getRatePeriodMs() {
        return this.ratePeriodMs;
    }

    public String getRateSuffix() {
        return this.rateSuffix;
    }

    public void setRateSuffix(String rateSuffix) {
        this.rateSuffix = rateSuffix;
    }

    public String getCounterSuffix() {
        return this.counterSuffix;
    }

    public void setCounterSuffix(String counterSuffix) {
        this.counterSuffix = counterSuffix;
    }

    public void setRatePeriodSeconds(long ratePeriodSeconds) {
        if (ratePeriodSeconds < 1L) {
            throw new IllegalArgumentException("Period value must by more than 0, currently " + ratePeriodSeconds);
        }
        this.ratePeriodMs = ratePeriodSeconds * 1000L;
    }
}

