/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.collector.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.axibase.collector.MessageWriter;
import com.axibase.collector.Utils;
import com.axibase.collector.config.SeriesSenderConfig;
import com.axibase.collector.config.Tag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LogbackMessageWriter<E extends ILoggingEvent>
implements MessageWriter<E> {
    private Map<String, String> tags = new LinkedHashMap<String, String>();
    private String entity = Utils.resolveHostname();
    private final Map<Key, Counter> story = new HashMap<Key, Counter>();
    private ByteBuffer seriesRatePrefix;
    private ByteBuffer seriesTotalRatePrefix;
    private ByteBuffer seriesTotalSumPrefix;
    private ByteBuffer messagePrefix;
    private SeriesSenderConfig seriesSenderConfig = SeriesSenderConfig.DEFAULT;
    private final Map<Level, CounterWithSum> totals = new HashMap<Level, CounterWithSum>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeStatMessages(WritableByteChannel writer, Collection<E> events, long deltaTime) throws IOException {
        if (deltaTime < 1L) {
            throw new IllegalArgumentException("Illegal delta tie value: " + deltaTime);
        }
        int zeroRepeatCount = this.seriesSenderConfig.getZeroRepeatCount();
        Iterator<Map.Entry<Level, CounterWithSum>> iterator = this.totals.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Level, CounterWithSum> entry = iterator.next();
            if (entry.getValue().zeroRepeats >= 0) continue;
            iterator.remove();
        }
        for (Counter counter : this.story.values()) {
            counter.decrementZeroRepeats();
        }
        for (ILoggingEvent event : events) {
            Key key = new Key(event.getLevel(), event.getLoggerName());
            Counter counter = this.story.get(key);
            if (counter == null) {
                this.story.put(key, new Counter(1, zeroRepeatCount));
                continue;
            }
            counter.increment();
            counter.setZeroRepeats(zeroRepeatCount);
        }
        long time = System.currentTimeMillis();
        Iterator<Map.Entry<Key, Counter>> iterator2 = this.story.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Key, Counter> entry = iterator2.next();
            Counter counter = entry.getValue();
            if (counter.zeroRepeats < 0) {
                iterator2.remove();
                continue;
            }
            Key key = entry.getKey();
            int value = counter.value;
            try {
                this.seriesRatePrefix.rewind();
                writer.write(this.seriesRatePrefix);
                StringBuilder sb = new StringBuilder();
                Level level = key.level;
                String levelString = level.toString();
                double rate = (double)value * (double)this.seriesSenderConfig.getRatePeriodMs() / (double)deltaTime;
                sb.append(rate);
                sb.append(" t:level=").append(levelString);
                sb.append(" t:logger=").append(Utils.sanitizeTagValue(key.logger));
                sb.append(" ms:").append(time).append("\n");
                writer.write(ByteBuffer.wrap(sb.toString().getBytes()));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                if (value > 0) {
                    CounterWithSum total = this.totals.get(key.level);
                    if (total == null) {
                        total = new CounterWithSum(value, zeroRepeatCount);
                        this.totals.put(key.level, total);
                    } else {
                        total.add(value);
                        total.setZeroRepeats(zeroRepeatCount);
                    }
                }
                counter.clean();
            }
        }
        for (Map.Entry<Level, CounterWithSum> entry : this.totals.entrySet()) {
            Level level = entry.getKey();
            CounterWithSum counterWithSum = entry.getValue();
            try {
                this.seriesTotalRatePrefix.rewind();
                writer.write(this.seriesTotalRatePrefix);
                StringBuilder sb = new StringBuilder();
                String levelString = level.toString();
                double rate = (double)counterWithSum.value * (double)this.seriesSenderConfig.getRatePeriodMs() / (double)deltaTime;
                sb.append(rate);
                sb.append(" t:level=").append(levelString);
                sb.append(" ms:").append(time).append("\n");
                writer.write(ByteBuffer.wrap(sb.toString().getBytes()));
                counterWithSum.clean();
                this.seriesTotalSumPrefix.rewind();
                writer.write(this.seriesTotalSumPrefix);
                sb = new StringBuilder();
                sb.append(counterWithSum.sum);
                sb.append(" t:level=").append(levelString);
                sb.append(" ms:").append(time).append("\n");
                writer.write(ByteBuffer.wrap(sb.toString().getBytes()));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                entry.getValue().decrementZeroRepeats();
            }
        }
    }

    @Override
    public void writeSingleMessage(WritableByteChannel writer, E event, int lines) throws IOException {
        this.messagePrefix.rewind();
        writer.write(this.messagePrefix);
        StringBuilder sb = new StringBuilder();
        String message = event.getFormattedMessage();
        if (lines > 0 && event.getCallerData() != null) {
            StringBuilder msb = new StringBuilder(message);
            for (int i = 0; i < event.getCallerData().length && i < lines; ++i) {
                StackTraceElement traceElement = event.getCallerData()[i];
                msb.append("\n\t").append(traceElement.toString());
            }
            message = msb.toString();
        }
        sb.append(Utils.sanitizeMessage(message));
        sb.append(" t:severity=").append(event.getLevel());
        sb.append(" t:level=").append(event.getLevel());
        sb.append(" t:source=").append(Utils.sanitizeTagValue(event.getLoggerName()));
        sb.append(" ms:").append(System.currentTimeMillis()).append("\n");
        writer.write(ByteBuffer.wrap(sb.toString().getBytes()));
    }

    @Override
    public void start() {
        String sanitizedEntity = Utils.sanitizeEntity(this.entity);
        StringBuilder sb = new StringBuilder();
        sb.append("series e:").append(sanitizedEntity);
        this.appendTags(sb);
        sb.append(" m:").append(Utils.sanitizeMetric(this.seriesSenderConfig.getMetric() + this.seriesSenderConfig.getRateSuffix())).append("=");
        this.seriesRatePrefix = ByteBuffer.wrap(sb.toString().getBytes(Utils.UTF_8));
        sb = new StringBuilder();
        sb.append("series e:").append(sanitizedEntity);
        this.appendTags(sb);
        sb.append(" m:").append(Utils.sanitizeMetric(this.seriesSenderConfig.getMetric() + this.seriesSenderConfig.getTotalSuffix() + this.seriesSenderConfig.getRateSuffix())).append("=");
        this.seriesTotalRatePrefix = ByteBuffer.wrap(sb.toString().getBytes(Utils.UTF_8));
        sb = new StringBuilder();
        sb.append("series e:").append(sanitizedEntity);
        this.appendTags(sb);
        sb.append(" m:").append(Utils.sanitizeMetric(this.seriesSenderConfig.getMetric() + this.seriesSenderConfig.getTotalSuffix() + this.seriesSenderConfig.getCounterSuffix())).append("=");
        this.seriesTotalSumPrefix = ByteBuffer.wrap(sb.toString().getBytes(Utils.UTF_8));
        sb = new StringBuilder();
        sb.append("message e:").append(sanitizedEntity);
        this.appendTags(sb);
        this.unsafeAppendTag(sb, "type", "logger");
        sb.append(" m:");
        this.messagePrefix = ByteBuffer.wrap(sb.toString().getBytes(Utils.UTF_8));
    }

    private void appendTags(StringBuilder sb) {
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            String tagName = Utils.sanitizeTagKey(entry.getKey());
            String tagValue = Utils.sanitizeTagValue(entry.getValue());
            this.unsafeAppendTag(sb, tagName, tagValue);
        }
    }

    private void unsafeAppendTag(StringBuilder sb, String tagName, String tagValue) {
        sb.append(" t:").append(tagName).append("=").append(tagValue);
    }

    @Override
    public void stop() {
    }

    public void addTag(Tag tag) {
        this.tags.put(tag.getName(), tag.getValue());
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public void setSeriesSenderConfig(SeriesSenderConfig seriesSenderConfig) {
        this.seriesSenderConfig = seriesSenderConfig;
    }

    private static class CounterWithSum
    extends Counter {
        private long sum;

        public CounterWithSum(int value, int zeroRepeats) {
            super(value, zeroRepeats);
        }

        @Override
        public void clean() {
            this.sum += (long)this.value;
            super.clean();
        }
    }

    private static class Counter {
        protected int value;
        protected int zeroRepeats;

        public Counter(int value, int zeroRepeats) {
            this.value = value;
            this.setZeroRepeats(zeroRepeats);
        }

        void increment() {
            ++this.value;
        }

        public void add(int value) {
            this.value += value;
        }

        void decrementZeroRepeats() {
            --this.zeroRepeats;
        }

        public void setZeroRepeats(int zeroRepeats) {
            this.zeroRepeats = zeroRepeats;
        }

        public void clean() {
            this.value = 0;
        }
    }

    private static class Key {
        private final Level level;
        private final String logger;

        public Key(Level level, String logger) {
            if (level == null) {
                throw new IllegalArgumentException("Level is null");
            }
            this.level = level;
            this.logger = logger;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.level != null ? !this.level.equals(key.level) : key.level != null) {
                return false;
            }
            return !(this.logger == null ? key.logger != null : !this.logger.equals(key.logger));
        }

        public int hashCode() {
            int result = this.level != null ? this.level.hashCode() : 0;
            result = 31 * result + (this.logger != null ? this.logger.hashCode() : 0);
            return result;
        }
    }
}

