/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.collector.writer;

import com.axibase.collector.writer.AbstractAtsdWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class TcpAtsdWriter
extends AbstractAtsdWriter {
    private SocketChannel client;

    public void connect() throws IllegalStateException, IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        InetSocketAddress address = this.getAddress();
        if (address.getAddress() == null) {
            throw new UnknownHostException(address.getHostName());
        }
        System.out.println("Connect to: " + this.getAddress());
        this.client = SocketChannel.open(address);
    }

    public boolean isConnected() {
        return this.client != null && this.client.socket().isConnected() && !this.client.socket().isClosed();
    }

    @Override
    public int write(ByteBuffer message) throws IOException {
        int cnt = 0;
        if (!this.isConnected()) {
            this.connect();
        }
        try {
            while (message.hasRemaining()) {
                this.client.write(message);
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return cnt;
    }

    @Override
    public boolean isOpen() {
        return this.isConnected();
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }
}

