/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.collector.writer;

import com.axibase.collector.writer.AbstractAtsdWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class UdpAtsdWriter
extends AbstractAtsdWriter {
    private DatagramChannel datagramChannel = null;

    public void connect() throws IllegalStateException, IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected");
        }
        if (this.datagramChannel != null) {
            this.datagramChannel.close();
        }
        this.datagramChannel = DatagramChannel.open();
    }

    public boolean isConnected() {
        return this.datagramChannel != null && !this.datagramChannel.socket().isClosed();
    }

    @Override
    public int write(ByteBuffer message) throws IOException {
        if (!this.isConnected()) {
            this.connect();
        }
        return this.datagramChannel.send(message, this.getAddress());
    }

    @Override
    public boolean isOpen() {
        return this.isConnected();
    }

    @Override
    public void close() throws IOException {
    }
}

