/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.example;

import com.axibase.tsd.client.ClientConfigurationFactory;
import com.axibase.tsd.client.DataService;
import com.axibase.tsd.client.HttpClientManager;
import com.axibase.tsd.client.MetaDataService;
import com.axibase.tsd.model.data.GetSeriesResult;
import com.axibase.tsd.model.data.Series;
import com.axibase.tsd.model.system.ClientConfiguration;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.util.Date;
import java.util.List;

public abstract class AbstractAtsdClientExample {
    public static final ISO8601DateFormat ISO_DATE_FORMAT = new ISO8601DateFormat();
    protected DataService dataService;
    protected MetaDataService metaDataService;

    protected void configure() {
        System.out.println("Getting Started with Axibase TSD");
        ClientConfiguration clientConfiguration = ClientConfigurationFactory.getInstance().createClientConfiguration();
        System.out.println("Connecting to ATSD: " + clientConfiguration.getMetadataUrl());
        HttpClientManager httpClientManager = new HttpClientManager(clientConfiguration);
        this.dataService = new DataService(httpClientManager);
        this.metaDataService = new MetaDataService(httpClientManager);
    }

    protected String toISODate(long time) {
        return ISO_DATE_FORMAT.format(new Date(time));
    }

    protected void print(GetSeriesResult getSeriesResult) {
        System.out.println("Time Series Key: " + getSeriesResult.getTimeSeriesKey());
        List<Series> data = getSeriesResult.getData();
        for (Series series : data) {
            long ts = series.getT();
            System.out.println(this.toISODate(ts) + "\t" + series.getV());
        }
    }
}

