/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.example;

import com.axibase.tsd.example.AbstractAtsdClientExample;
import com.axibase.tsd.model.data.GetSeriesResult;
import com.axibase.tsd.model.data.Interval;
import com.axibase.tsd.model.data.IntervalUnit;
import com.axibase.tsd.model.data.command.GetSeriesCommand;
import com.axibase.tsd.model.meta.EntityAndTags;
import com.axibase.tsd.model.meta.Metric;
import java.util.List;
import java.util.Map;

public class AtsdClientReadExample
extends AbstractAtsdClientExample {
    public static void main(String[] args) {
        AtsdClientReadExample atsdClientReadExample = new AtsdClientReadExample();
        atsdClientReadExample.configure();
        atsdClientReadExample.printMetaDataAndData("disk_used_percent");
    }

    private void printMetaDataAndData(String metricExample) {
        Metric metric = this.metaDataService.retrieveMetric(metricExample);
        if (metric == null) {
            System.out.println("Unknown metric: " + metricExample);
            return;
        }
        List<EntityAndTags> entityAndTagsList = this.metaDataService.retrieveEntityAndTags(metric.getName(), null);
        System.out.println("===Metric MetaData===");
        System.out.println("Metric: " + metric.getName());
        for (EntityAndTags entityAndTags : entityAndTagsList) {
            String entityName = entityAndTags.getEntityName();
            System.out.println("\n===Entity MetaData===");
            System.out.println("Entity: " + entityName);
            Map<String, String> tags = entityAndTags.getTags();
            System.out.println("===Tags===");
            for (Map.Entry<String, String> tagAndValue : tags.entrySet()) {
                System.out.println("\t" + tagAndValue.getKey() + " : " + tagAndValue.getValue());
            }
            System.out.println("===Series===");
            GetSeriesCommand command = new GetSeriesCommand(entityName, metric.getName(), tags);
            List<GetSeriesResult> getSeriesResults = this.dataService.retrieveSeries(new Interval(1, IntervalUnit.MINUTE), 10, command);
            for (GetSeriesResult getSeriesResult : getSeriesResults) {
                this.print(getSeriesResult);
            }
        }
    }
}

