/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.command;

import com.axibase.tsd.model.data.IntervalUnit;
import com.axibase.tsd.model.data.RateUnit;
import com.axibase.tsd.model.data.SeriesType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetSeriesCommand {
    @JsonProperty(value="entity")
    private String entityName;
    @JsonProperty(value="metric")
    private String metricName;
    private MultivaluedMap<String, String> tags = new MultivaluedHashMap();
    private SeriesType type;
    private Integer intervalCount;
    private IntervalUnit intervalUnit;
    private Integer rateCount;
    private RateUnit rateUnit;
    private String statistics;
    private boolean multipleSeries;

    public GetSeriesCommand() {
    }

    public GetSeriesCommand(String entityName, String metricName, MultivaluedMap<String, String> tags) {
        this.entityName = entityName;
        this.metricName = metricName;
        this.tags = tags;
    }

    public GetSeriesCommand(String entityName, String metricName, Map<String, String> tags) {
        this.entityName = entityName;
        this.metricName = metricName;
        this.tags = new MultivaluedHashMap(tags);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public MultivaluedMap<String, String> getTags() {
        return this.tags;
    }

    public void setTags(MultivaluedMap<String, String> tags) {
        this.tags = tags;
    }

    public SeriesType getType() {
        return this.type;
    }

    public void setType(SeriesType type) {
        this.type = type;
    }

    public Integer getIntervalCount() {
        return this.intervalCount;
    }

    public void setIntervalCount(Integer intervalCount) {
        this.intervalCount = intervalCount;
    }

    public IntervalUnit getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(IntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public Integer getRateCount() {
        return this.rateCount;
    }

    public void setRateCount(Integer rateCount) {
        this.rateCount = rateCount;
    }

    public RateUnit getRateUnit() {
        return this.rateUnit;
    }

    public void setRateUnit(RateUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    public String getStatistics() {
        return this.statistics;
    }

    public void setStatistics(String statistics) {
        this.statistics = statistics;
    }

    public boolean isMultipleSeries() {
        return this.multipleSeries;
    }

    public void setMultipleSeries(boolean multipleSeries) {
        this.multipleSeries = multipleSeries;
    }

    @JsonIgnore
    public void setInterval(IntervalUnit unit, int count) {
        this.setIntervalUnit(unit);
        this.setIntervalCount(count);
    }

    public String toString() {
        return "Series{entityName='" + this.entityName + '\'' + ", metricName='" + this.metricName + '\'' + ", tags=" + this.tags + ", type=" + (Object)((Object)this.type) + ", intervalCount=" + this.intervalCount + ", intervalUnit=" + (Object)((Object)this.intervalUnit) + ", rateCount=" + this.rateCount + ", rateUnit=" + (Object)((Object)this.rateUnit) + ", statistics='" + this.statistics + '\'' + ", multipleSeries=" + this.multipleSeries + '}';
    }
}

