/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.collector;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class Utils {
    public static final String DEFAULT_ENTITY = "defaultEntity";
    private static final Pattern SPACE = Pattern.compile("[[\\s]]");
    private static final Pattern QUOTES = Pattern.compile("[['|\"]]");
    private static final Pattern D_QUOTE = Pattern.compile("[[\"]]");
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static String sanitizeEntity(String s) {
        return Utils.sanitize(s);
    }

    public static String sanitizeMetric(String s) {
        return Utils.sanitize(s);
    }

    public static String sanitizeTagKey(String s) {
        return Utils.sanitize(s);
    }

    public static String sanitizeTagValue(String s) {
        if ((s = D_QUOTE.matcher(s).replaceAll("\\\\\"")).contains(" ") || s.contains("=")) {
            StringBuilder sb = new StringBuilder("\"");
            s = sb.append(s).append("\"").toString();
        }
        return s;
    }

    public static String sanitizeMessage(String s) {
        if ((s = D_QUOTE.matcher(s).replaceAll("\\\\\"")).contains(" ")) {
            StringBuilder sb = new StringBuilder("\"");
            s = sb.append(s).append("\"").toString();
        }
        return s;
    }

    public static String sanitize(String s) {
        s = SPACE.matcher(s).replaceAll("_");
        s = QUOTES.matcher(s).replaceAll("");
        return s;
    }

    public static String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return DEFAULT_ENTITY;
        }
    }
}

