/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.collector;

import java.util.concurrent.ConcurrentLinkedQueue;

public class CountedQueue<E>
extends ConcurrentLinkedQueue<E> {
    private volatile int count;

    @Override
    public boolean offer(E e) {
        boolean offer = super.offer(e);
        if (offer) {
            ++this.count;
        }
        return offer;
    }

    @Override
    public E poll() {
        Object value = super.poll();
        if (this.count > 0) {
            --this.count;
        }
        return value;
    }

    public void clearCount() {
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }
}

