/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.util;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AtsdUtil {
    public static final String JSON = "application/json";
    public static final String ADD_COMMAND = "add";
    public static final String DELETE_COMMAND = "delete";
    public static final String MARKER_KEYWORD = "marker ";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String PING_COMMAND = "ping\n";
    public static final String SAFE_PING_COMMAND = "\nping\n";

    public static Map<String, String> toMap(String ... tagNamesAndValues) {
        if (tagNamesAndValues == null || tagNamesAndValues.length == 0) {
            return Collections.emptyMap();
        }
        if (tagNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Key without value");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < tagNamesAndValues.length; ++i) {
            result.put(tagNamesAndValues[i], tagNamesAndValues[++i]);
        }
        return result;
    }

    public static Map<String, Double> toValuesMap(Object ... metricNamesAndValues) {
        if (metricNamesAndValues == null || metricNamesAndValues.length == 0) {
            return Collections.emptyMap();
        }
        if (metricNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Key without value");
        }
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < metricNamesAndValues.length; ++i) {
            result.put((String)metricNamesAndValues[i], (Double)metricNamesAndValues[++i]);
        }
        return result;
    }

    public static void check(String value, String errorMessage) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkEntityName(String entityName) {
        AtsdUtil.check(entityName, "Entity name is empty");
    }

    public static void checkEntityGroupName(String entityGroupName) {
        AtsdUtil.check(entityGroupName, "Entity group name is empty");
    }

    public static void checkMetricName(String metricName) {
        AtsdUtil.check(metricName, "Metric name is empty");
    }
}

