/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

class RequestProcessor<T> {
    private Type type;
    private T command;

    private RequestProcessor(Type type, T command) {
        this.type = type;
        this.command = command;
    }

    public Response process(Invocation.Builder request, String mediaType) {
        if (this.type == Type.DELETE) {
            return request.accept(new String[]{"application/json", mediaType}).delete();
        }
        return request.accept(new String[]{"application/json", mediaType}).method(this.type.name(), Entity.entity(this.command, (String)mediaType));
    }

    public static <T> RequestProcessor<T> post(T command) {
        return new RequestProcessor<T>(Type.POST, command);
    }

    public static <T> RequestProcessor<T> put(T command) {
        return new RequestProcessor<T>(Type.PUT, command);
    }

    public static <T> RequestProcessor<T> patch(T command) {
        return new RequestProcessor<T>(Type.PATCH, command);
    }

    public static <T> RequestProcessor<T> delete() {
        return new RequestProcessor<Object>(Type.DELETE, null);
    }

    public static enum Type {
        POST,
        PUT,
        PATCH,
        DELETE;

    }
}

