/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.example;

import com.axibase.tsd.client.ClientConfigurationFactory;
import com.axibase.tsd.client.DataService;
import com.axibase.tsd.client.HttpClientManager;
import com.axibase.tsd.client.MetaDataService;
import com.axibase.tsd.model.data.series.GetSeriesResult;
import com.axibase.tsd.model.data.series.Series;
import com.axibase.tsd.model.system.ClientConfiguration;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public abstract class AbstractAtsdClientExample {
    public static final ISO8601DateFormat ISO_DATE_FORMAT = new ISO8601DateFormat();
    protected DataService dataService;
    protected MetaDataService metaDataService;

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public void setMetaDataService(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    protected void configure() {
        System.out.println("Getting Started with Axibase TSD");
        ClientConfiguration clientConfiguration = ClientConfigurationFactory.createInstance().createClientConfiguration();
        System.out.println("Connecting to ATSD: " + clientConfiguration.getMetadataUrl());
        HttpClientManager httpClientManager = new HttpClientManager(clientConfiguration);
        this.dataService = new DataService(httpClientManager);
        this.metaDataService = new MetaDataService(httpClientManager);
    }

    protected void pureJavaConfigure() {
        ClientConfigurationFactory configurationFactory = new ClientConfigurationFactory("http", "writeyourownservername.com", 8088, "/api/v1", "/api/v1", "username", "pwd", 3, 3, false);
        ClientConfiguration clientConfiguration = configurationFactory.createClientConfiguration();
        System.out.println("Connecting to ATSD: " + clientConfiguration.getMetadataUrl());
        HttpClientManager httpClientManager = new HttpClientManager(clientConfiguration);
        GenericObjectPoolConfig objectPoolConfig = new GenericObjectPoolConfig();
        objectPoolConfig.setMaxTotal(5);
        objectPoolConfig.setMaxIdle(5);
        httpClientManager.setObjectPoolConfig(objectPoolConfig);
        httpClientManager.setBorrowMaxWaitMillis(1000);
        this.dataService = new DataService(httpClientManager);
        this.metaDataService = new MetaDataService(httpClientManager);
    }

    public static void main(String[] args) {
    }

    protected String toISODate(long time) {
        return ISO_DATE_FORMAT.format(new Date(time));
    }

    protected void print(GetSeriesResult getSeriesResult) {
        System.out.println("Time Series Key: " + getSeriesResult.getTimeSeriesKey());
        List<Series> data = getSeriesResult.getData();
        for (Series series : data) {
            long ts = series.getT();
            System.out.println(this.toISODate(ts) + "\t" + series.getV());
        }
    }
}

