/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.plain.PlainCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlainSender
extends AbstractHttpEntity
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PlainSender.class);
    public static final String PING_COMMAND = "ping\n";
    private String url;
    private CountDownLatch latch = new CountDownLatch(1);
    private CloseableHttpClient httpClient;
    private BlockingQueue<String> messages;
    private volatile boolean active;
    private final long pingTimeoutMillis;
    private long lastMessageTime;
    private CloseableHttpResponse response;

    public PlainSender(String url, long pingTimeoutMillis) {
        this.url = url;
        this.pingTimeoutMillis = pingTimeoutMillis;
    }

    public void send(PlainCommand plainCommand) {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            log.error("Initialization error:", (Throwable)e);
        }
        String message = plainCommand.compose();
        try {
            this.messages.put(message);
        }
        catch (InterruptedException e) {
            log.error("Could not put message: {}", (Object)message, (Object)e);
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return true;
    }

    public long getContentLength() {
        return -1L;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        while (this.active) {
            try {
                String message = this.messages.poll(this.pingTimeoutMillis, TimeUnit.MILLISECONDS);
                if (message != null) {
                    outputStream.write(message.getBytes());
                    outputStream.flush();
                    this.lastMessageTime = System.currentTimeMillis();
                }
                if (this.lastMessageTime - System.currentTimeMillis() <= this.pingTimeoutMillis) continue;
                outputStream.write(PING_COMMAND.getBytes());
                outputStream.flush();
                this.lastMessageTime = System.currentTimeMillis();
            }
            catch (InterruptedException e) {
                log.error("Could not poll message from queue", (Throwable)e);
            }
        }
    }

    public boolean isStreaming() {
        return true;
    }

    public void close() {
        this.active = false;
        if (this.response != null) {
            try {
                this.response.close();
            }
            catch (IOException e) {
                log.error("Could not close response: {}", (Object)this.response, (Object)e);
            }
        }
        if (this.httpClient == null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.error("Could not close client: {}", (Object)this.httpClient, (Object)e);
            }
        }
    }

    @Override
    public void run() {
        this.messages = new LinkedBlockingQueue<String>();
        this.latch.countDown();
        this.httpClient = HttpClients.custom().build();
        HttpPost httpPost = new HttpPost(this.url + "/command");
        httpPost.setEntity((HttpEntity)this);
        try {
            this.active = true;
            this.response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            log.error("Could not execute HTTP POST: {}", (Object)httpPost, (Object)e);
        }
    }
}

