/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.plain.PlainCommand;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PlainSender
extends AbstractHttpEntity
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PlainSender.class);
    private static final String PING_COMMAND = "ping\n";
    private static final int SMALL = 64;
    private String url;
    private CountDownLatch latch = new CountDownLatch(1);
    private CloseableHttpClient httpClient;
    private BlockingQueue<String> messages;
    private volatile boolean active;
    private volatile boolean correct = true;
    private final long pingTimeoutMillis;
    private long lastMessageTime;
    private CloseableHttpResponse response;

    public PlainSender(String url, long pingTimeoutMillis, PlainSender old) {
        this.url = url;
        this.pingTimeoutMillis = pingTimeoutMillis;
        if (old != null) {
            this.messages = old.messages;
            log.info("Reborn plain commands sender using previous messages, size: {}", (Object)this.messages.size());
        }
    }

    public void send(PlainCommand plainCommand) {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            log.error("Initialization error:", (Throwable)e);
        }
        this.messages.add(plainCommand.compose());
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        while (this.active) {
            String message = null;
            try {
                message = this.messages.poll(this.pingTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.error("Could not poll message from queue", (Throwable)e);
            }
            try {
                if (message != null) {
                    outputStream.write(message.getBytes());
                    outputStream.flush();
                    this.lastMessageTime = System.currentTimeMillis();
                }
            }
            catch (Throwable e) {
                this.active = false;
                this.correct = false;
                log.error("Sender is died. Could not send message: {}", (Object)message, (Object)e);
                this.messages.add(message);
                this.close();
                return;
            }
            if (this.lastMessageTime - System.currentTimeMillis() <= this.pingTimeoutMillis) continue;
            outputStream.write(PING_COMMAND.getBytes());
            outputStream.flush();
            this.lastMessageTime = System.currentTimeMillis();
        }
    }

    public boolean isStreaming() {
        return true;
    }

    public void close() {
        this.active = false;
        if (this.response != null) {
            try {
                this.response.close();
            }
            catch (IOException e) {
                log.error("Could not close response: {}", (Object)this.response, (Object)e);
            }
        }
        if (this.httpClient == null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.error("Could not close client: {}", (Object)this.httpClient, (Object)e);
            }
        }
    }

    @Override
    public void run() {
        if (this.messages == null) {
            this.messages = new LinkedBlockingQueue<String>();
        }
        this.latch.countDown();
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager();
        connManager.setConnectionConfig(ConnectionConfig.custom().setBufferSize(64).build());
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
        HttpPost httpPost = new HttpPost(this.url + "/command");
        httpPost.setEntity((HttpEntity)this);
        try {
            this.active = true;
            this.response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            log.error("Could not execute HTTP POST: {}", (Object)httpPost, (Object)e);
        }
    }

    public boolean isCorrect() {
        return this.correct;
    }
}

