/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.client.AtsdServerException;
import com.axibase.tsd.client.HttpClientManager;
import com.axibase.tsd.client.RequestProcessor;
import com.axibase.tsd.model.meta.Entity;
import com.axibase.tsd.model.meta.EntityAndTags;
import com.axibase.tsd.model.meta.EntityGroup;
import com.axibase.tsd.model.meta.Metric;
import com.axibase.tsd.model.meta.TagAppender;
import com.axibase.tsd.model.meta.command.AddEntitiesCommand;
import com.axibase.tsd.model.meta.command.DeleteEntitiesCommand;
import com.axibase.tsd.model.meta.command.SimpleCommand;
import com.axibase.tsd.query.Query;
import com.axibase.tsd.query.QueryPart;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Arrays;
import java.util.List;

public class MetaDataService {
    private HttpClientManager httpClientManager;

    public MetaDataService() {
    }

    public MetaDataService(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public void setHttpClientManager(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public List<Metric> retrieveMetrics(Boolean active, String expression, TagAppender tagAppender, Integer limit) throws AtsdClientException, AtsdServerException {
        QueryPart query = new Query("metrics").param("active", active).param("expression", expression).param("limit", limit);
        if (tagAppender != null) {
            query = query.param("tags", tagAppender.getTags());
        }
        return this.httpClientManager.requestMetaDataList(Metric.class, query);
    }

    public List<Metric> retrieveMetrics(String entityName, Boolean active, String expression, TagAppender tagAppender, Integer limit) throws AtsdClientException, AtsdServerException {
        QueryPart query = new Query("entities").path(entityName).path("metrics").param("active", active).param("expression", expression).param("limit", limit);
        if (tagAppender != null) {
            query = query.param("tags", tagAppender.getTags());
        }
        return this.httpClientManager.requestMetaDataList(Metric.class, query);
    }

    public Metric retrieveMetric(String metricName) throws AtsdClientException, AtsdServerException {
        AtsdUtil.checkMetricName(metricName);
        return this.httpClientManager.requestMetaDataObject(Metric.class, new Query("metrics").path(metricName));
    }

    public boolean createOrReplaceMetric(Metric metric) {
        String metricName = metric.getName();
        AtsdUtil.checkMetricName(metricName);
        QueryPart queryPart = new Query("metrics").path(metricName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.put(metric));
    }

    public boolean updateMetric(Metric metric) {
        String metricName = metric.getName();
        AtsdUtil.checkMetricName(metricName);
        QueryPart queryPart = new Query("metrics").path(metricName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.patch(metric));
    }

    public boolean deleteMetric(Metric metric) {
        String metricName = metric.getName();
        AtsdUtil.checkMetricName(metricName);
        QueryPart queryPart = new Query("metrics").path(metricName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.delete());
    }

    public List<Entity> retrieveEntities(Boolean active, String expression, TagAppender tagAppender, Integer limit) throws AtsdClientException, AtsdServerException {
        QueryPart query = new Query("entities").param("active", active).param("expression", expression).param("limit", limit);
        if (tagAppender != null) {
            query = query.param("tags", tagAppender.getTags());
        }
        return this.httpClientManager.requestMetaDataList(Entity.class, query);
    }

    public Entity retrieveEntity(String entityName) throws AtsdClientException, AtsdServerException {
        AtsdUtil.checkEntityName(entityName);
        QueryPart query = new Query("entities").path(entityName);
        return this.httpClientManager.requestMetaDataObject(Entity.class, query);
    }

    public boolean createOrReplaceEntity(Entity entity) {
        String entityName = entity.getName();
        AtsdUtil.checkEntityName(entityName);
        QueryPart queryPart = new Query("entities").path(entityName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.put(entity));
    }

    public boolean updateEntity(Entity entity) {
        String entityName = entity.getName();
        AtsdUtil.checkEntityName(entityName);
        QueryPart queryPart = new Query("entities").path(entityName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.patch(entity));
    }

    public boolean deleteEntity(Entity entity) {
        String entityName = entity.getName();
        AtsdUtil.checkEntityName(entityName);
        QueryPart queryPart = new Query("entities").path(entityName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.delete());
    }

    public List<EntityAndTags> retrieveEntityAndTags(String metricName, String entityName) throws AtsdClientException, AtsdServerException {
        AtsdUtil.checkMetricName(metricName);
        return this.httpClientManager.requestMetaDataList(EntityAndTags.class, new Query("metrics").path(metricName).path("entity-and-tags").param("entity", entityName));
    }

    public List<EntityGroup> retrieveEntityGroups() throws AtsdClientException, AtsdServerException {
        return this.httpClientManager.requestMetaDataList(EntityGroup.class, new Query("entity-groups"));
    }

    public EntityGroup retrieveEntityGroup(String entityGroupName) throws AtsdClientException, AtsdServerException {
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName);
        return this.httpClientManager.requestMetaDataObject(EntityGroup.class, query);
    }

    public boolean createOrReplaceEntityGroup(EntityGroup entityGroup) throws AtsdClientException, AtsdServerException {
        String entityGroupName = entityGroup.getName();
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName);
        return this.httpClientManager.updateMetaData(query, RequestProcessor.put(entityGroup));
    }

    public boolean updateEntityGroup(EntityGroup entityGroup) throws AtsdClientException, AtsdServerException {
        String entityGroupName = entityGroup.getName();
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName);
        return this.httpClientManager.updateMetaData(query, RequestProcessor.patch(entityGroup));
    }

    public boolean deleteEntityGroup(EntityGroup entityGroup) throws AtsdClientException, AtsdServerException {
        String entityGroupName = entityGroup.getName();
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName);
        return this.httpClientManager.updateMetaData(query, RequestProcessor.delete());
    }

    public List<Entity> retrieveGroupEntities(String entityGroupName, Boolean active, String expression, TagAppender tagAppender, Integer limit) throws AtsdClientException, AtsdServerException {
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities").param("active", active).param("expression", expression).param("limit", limit);
        if (tagAppender != null) {
            query = query.param("tags", tagAppender.getTags());
        }
        return this.httpClientManager.requestMetaDataList(Entity.class, query);
    }

    public List<Entity> retrieveGroupEntities(String entityGroupName) throws AtsdClientException, AtsdServerException {
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities");
        query = query.param("tags", TagAppender.ALL.getTags());
        return this.httpClientManager.requestMetaDataList(Entity.class, query);
    }

    public boolean addGroupEntities(String entityGroupName, Boolean createEntities, Entity ... entities) {
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities").param("createEntities", createEntities);
        AddEntitiesCommand addEntitiesCommand = new AddEntitiesCommand(createEntities, Arrays.asList(entities));
        return this.httpClientManager.updateMetaData(query, RequestProcessor.patch(Arrays.asList(addEntitiesCommand)));
    }

    public boolean replaceGroupEntities(String entityGroupName, Boolean createEntities, Entity ... entities) {
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities").param("createEntities", createEntities);
        return this.httpClientManager.updateMetaData(query, RequestProcessor.put(Arrays.asList(entities)));
    }

    public boolean deleteGroupEntities(String entityGroupName, Entity ... entities) {
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities");
        DeleteEntitiesCommand deleteEntitiesCommand = new DeleteEntitiesCommand(Arrays.asList(entities));
        return this.httpClientManager.updateMetaData(query, RequestProcessor.patch(Arrays.asList(deleteEntitiesCommand)));
    }

    public boolean deleteAllGroupEntities(String entityGroupName) {
        AtsdUtil.checkEntityGroupName(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities");
        return this.httpClientManager.updateMetaData(query, RequestProcessor.patch(Arrays.asList(new SimpleCommand("delete-all"))));
    }
}

