/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.plain;

import com.axibase.tsd.plain.PlainCommand;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractInsertCommand
implements PlainCommand {
    private final String commandName;
    protected final String entityName;
    private final Long timeMillis;
    protected final Map<String, String> tags;

    public AbstractInsertCommand(String commandName, String entityName, Long timeMillis, Map<String, String> tags) {
        this.commandName = commandName;
        AtsdUtil.checkEntityName(entityName);
        this.entityName = entityName;
        this.timeMillis = timeMillis;
        this.tags = tags == null ? Collections.emptyMap() : tags;
    }

    @Override
    public final String compose() {
        StringBuilder sb = new StringBuilder(this.commandName).append(' ').append("e:").append(AbstractInsertCommand.clean(this.entityName));
        if (this.timeMillis != null) {
            sb.append(' ').append("ms:").append(this.timeMillis);
        }
        AbstractInsertCommand.appendKeysAndValues(sb, " t:", this.tags);
        this.appendValues(sb);
        return sb.append('\n').toString();
    }

    protected static void appendKeysAndValues(StringBuilder sb, String prefix, Map<String, String> map) {
        for (Map.Entry<String, String> tagNameAndValue : map.entrySet()) {
            sb.append(prefix).append(AbstractInsertCommand.clean(tagNameAndValue.getKey())).append('=').append(AbstractInsertCommand.normalize(tagNameAndValue.getValue()));
        }
    }

    protected abstract void appendValues(StringBuilder var1);

    protected static String normalize(String value) {
        if (value.contains(" ") || value.contains("\"") || value.contains("=")) {
            return "\"" + value + "\"";
        }
        return value;
    }

    protected static String clean(String value) {
        AtsdUtil.check(value, "Value is empty: " + value);
        return StringUtils.replacePattern((String)value.trim(), (String)"[\\s'\"]", (String)"_");
    }
}

