/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.client.DefaultStreamingManager;
import com.axibase.tsd.client.HttpClient;
import com.axibase.tsd.client.RequestProcessor;
import com.axibase.tsd.client.StreamingManager;
import com.axibase.tsd.model.system.ClientConfiguration;
import com.axibase.tsd.plain.PlainCommand;
import com.axibase.tsd.query.QueryPart;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientManager {
    private static final Logger log = LoggerFactory.getLogger(HttpClientManager.class);
    private static final int DEFAULT_BORROW_MAX_TIME_MS = 3000;
    private static final int DEFAULT_MAX_TOTAL = 100;
    private static final int DEFAULT_MAX_IDLE = 100;
    private ClientConfiguration clientConfiguration;
    private GenericObjectPoolConfig objectPoolConfig;
    private AtomicReference<GenericObjectPool<HttpClient>> objectPoolAtomicReference = new AtomicReference();
    private int borrowMaxWaitMillis = 3000;
    private StreamingManager streamingManager = new DefaultStreamingManager(this);

    public HttpClientManager() {
        this.objectPoolConfig = new GenericObjectPoolConfig();
        this.objectPoolConfig.setMaxTotal(100);
        this.objectPoolConfig.setMaxIdle(100);
    }

    public HttpClientManager(ClientConfiguration clientConfiguration) {
        this();
        this.clientConfiguration = clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public void setObjectPoolConfig(GenericObjectPoolConfig objectPoolConfig) {
        this.objectPoolConfig = objectPoolConfig;
    }

    public void setBorrowMaxWaitMillis(int borrowMaxWaitMillis) {
        this.borrowMaxWaitMillis = borrowMaxWaitMillis;
    }

    public void setStreamingManager(StreamingManager streamingManager) {
        this.streamingManager = streamingManager;
    }

    public void setCheckPeriodMillis(long checkPeriodMillis) {
        this.streamingManager.setCheckPeriodMillis(checkPeriodMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> requestMetaDataList(Class<T> clazz, QueryPart<T> query) {
        HttpClient httpClient = this.borrowClient();
        try {
            List<T> list = httpClient.requestMetaDataList(clazz, query);
            return list;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T requestMetaDataObject(Class<T> clazz, QueryPart<T> query) {
        HttpClient httpClient = this.borrowClient();
        try {
            T t = httpClient.requestMetaDataObject(clazz, query);
            return t;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> boolean updateMetaData(QueryPart query, RequestProcessor<E> requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            boolean bl = httpClient.updateMetaData(query, requestProcessor);
            return bl;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateData(QueryPart query, RequestProcessor requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            boolean bl = httpClient.updateData(query, requestProcessor);
            return bl;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateData(QueryPart query, String data) {
        HttpClient httpClient = this.borrowClient();
        try {
            boolean bl = httpClient.updateData(query, data);
            return bl;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E> List<T> requestDataList(Class<T> clazz, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            List<T> list = httpClient.requestDataList(clazz, query, requestProcessor);
            return list;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E> T requestData(Class<T> clazz, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            T t = httpClient.requestData(clazz, query, requestProcessor);
            return t;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream requestInputStream(QueryPart query, RequestProcessor requestProcessor) {
        HttpClient httpClient = this.borrowClient();
        try {
            InputStream inputStream = httpClient.requestInputStream(query, requestProcessor);
            return inputStream;
        }
        finally {
            this.returnClient(httpClient);
        }
    }

    private HttpClient borrowClient() {
        HttpClient httpClient;
        GenericObjectPool<HttpClient> objectPool = this.createObjectPool();
        try {
            httpClient = (HttpClient)objectPool.borrowObject((long)this.borrowMaxWaitMillis);
        }
        catch (Exception e) {
            throw new AtsdClientException("Could not borrow http client from pool", e);
        }
        return httpClient;
    }

    private void returnClient(HttpClient httpClient) {
        this.objectPoolAtomicReference.get().returnObject((Object)httpClient);
    }

    private GenericObjectPool<HttpClient> createObjectPool() {
        GenericObjectPool httpClientGenericObjectPool = this.objectPoolAtomicReference.get();
        if (httpClientGenericObjectPool == null) {
            httpClientGenericObjectPool = new GenericObjectPool((PooledObjectFactory)new HttpClientBasePooledObjectFactory(), this.objectPoolConfig);
            this.objectPoolAtomicReference.compareAndSet(null, (GenericObjectPool<HttpClient>)httpClientGenericObjectPool);
        }
        return this.objectPoolAtomicReference.get();
    }

    public void close() {
        GenericObjectPool<HttpClient> pool = this.objectPoolAtomicReference.get();
        if (pool != null) {
            pool.close();
        }
        this.streamingManager.close();
    }

    public void send(PlainCommand plainCommand) {
        this.streamingManager.send(plainCommand);
    }

    public boolean canSendPlainCommand() {
        return this.streamingManager.canSend();
    }

    public List<String> removeSavedPlainCommands() {
        return this.streamingManager.removeSavedPlainCommands();
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    private class HttpClientBasePooledObjectFactory
    extends BasePooledObjectFactory<HttpClient> {
        private HttpClientBasePooledObjectFactory() {
        }

        public HttpClient create() throws Exception {
            return new HttpClient(HttpClientManager.this.clientConfiguration);
        }

        public PooledObject<HttpClient> wrap(HttpClient httpClient) {
            return new DefaultPooledObject((Object)httpClient);
        }

        public void destroyObject(PooledObject<HttpClient> p) throws Exception {
            ((HttpClient)p.getObject()).close();
        }
    }
}

