/*
 * Copyright 2016 Axibase Corporation or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 * https://www.axibase.com/atsd/axibase-apache-2.0.pdf
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.axibase.tsd.model.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Nikolay Malevanny.
 */
public enum TimeFormat {
    MILLISECONDS,
    ISO;

    @JsonCreator
    public static TimeFormat newInstance(String key) {
        if (StringUtils.isBlank(key)) {
            return MILLISECONDS;
        }
        return TimeFormat.valueOf(key.trim().toUpperCase());
    }
}
