/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.example;

import com.axibase.tsd.client.SeriesCommandPreparer;
import com.axibase.tsd.example.AbstractAtsdClientExample;
import com.axibase.tsd.model.data.command.AddSeriesCommand;
import com.axibase.tsd.model.data.command.GetSeriesQuery;
import com.axibase.tsd.model.data.series.Series;
import com.axibase.tsd.util.AtsdUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AtsdClientWriteExample
extends AbstractAtsdClientExample {
    public static final long SECOND = 1000L;
    public static final int MB = 0x100000;
    public static final int CNT = 10;
    private static final double MAX_VALUE = 1517191.0;
    private String hostName;

    public static void main(String[] args) {
        AtsdClientWriteExample atsdClientWriteExample = new AtsdClientWriteExample();
        atsdClientWriteExample.configure();
        atsdClientWriteExample.writeData();
        atsdClientWriteExample.printData();
    }

    private void sendToAtsd(double totalMemoryMb, double freeMemoryMb) {
        this.hostName = "localhost";
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        long time = System.currentTimeMillis();
        this.dataService.addSeries(AddSeriesCommand.createSingle(this.hostName, "total_memory_mb", time, totalMemoryMb, "app_name", "atsd_writer_example"), AddSeriesCommand.createSingle(this.hostName, "free_memory_mb", time, freeMemoryMb, "app_name", "atsd_writer_example"));
    }

    protected void printData() {
        Map<String, String> tags = AtsdUtil.toMap("app_name", "atsd_writer_example");
        List<Series> series = this.dataService.retrieveSeries(new SeriesCommandPreparer(){

            @Override
            public void prepare(GetSeriesQuery command) {
                command.setLimit(10);
                command.setStartTime(System.currentTimeMillis() - 12000L);
                command.setEndTime(System.currentTimeMillis());
            }
        }, new GetSeriesQuery(this.hostName, "total_memory_mb", tags), new GetSeriesQuery(this.hostName, "free_memory_mb", tags));
        this.logger.info("===Sample===");
        for (Series s : series) {
            this.print(s);
        }
    }

    protected void writeData() {
        this.logger.info("Writing memory usage metrics to ATSD ...");
        Runtime runtime = Runtime.getRuntime();
        HashSet<String> memoryEater = new HashSet<String>();
        for (int i = 0; i < 10; ++i) {
            long st = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            int k = 0;
            while ((double)k < 1517191.0 * (((double)i + 0.0) / 10.0)) {
                sb.append(String.valueOf(k));
                ++k;
            }
            memoryEater.add(sb.toString());
            long totalMemoryMb = runtime.totalMemory() / 0x100000L;
            long freeMemoryMb = runtime.freeMemory() / 0x100000L;
            this.sendToAtsd(totalMemoryMb, freeMemoryMb);
            try {
                long delta = System.currentTimeMillis() - st;
                if (delta < 1000L) {
                    Thread.sleep(1000L - delta);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.print(i + " ");
        }
        this.logger.info("\n");
    }
}

