/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.command;

import com.axibase.tsd.model.data.series.Sample;
import com.axibase.tsd.util.AtsdUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AddSeriesCommand {
    @JsonProperty(value="entity")
    private String entityName;
    @JsonProperty(value="metric")
    private String metricName;
    private Map<String, String> tags;
    private List<Sample> data;

    public AddSeriesCommand() {
    }

    public AddSeriesCommand(String entityName, String metricName, String ... tagNamesAndValues) {
        this.entityName = entityName;
        this.metricName = metricName;
        this.tags = AtsdUtil.toMap(tagNamesAndValues);
    }

    public static AddSeriesCommand createSingle(String entityName, String metricName, long time, double value, String ... tagNamesAndValues) {
        AddSeriesCommand addSeriesCommand = new AddSeriesCommand(entityName, metricName, tagNamesAndValues);
        addSeriesCommand.addSeries(new Sample(time, value));
        return addSeriesCommand;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public List<Sample> getData() {
        return this.data;
    }

    public AddSeriesCommand addSeries(Sample sample) {
        return this.addSeries(Collections.singleton(sample));
    }

    public AddSeriesCommand addSeries(Collection<Sample> samples) {
        if (this.data == null) {
            this.data = new ArrayList<Sample>();
        }
        this.data.addAll(samples);
        return this;
    }

    public AddSeriesCommand addSeries(Sample ... series) {
        return this.addSeries(Arrays.asList(series));
    }

    public AddSeriesCommand setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AddSeriesCommand setEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public AddSeriesCommand setMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }
}

