/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.command;

import com.axibase.tsd.model.data.TimeFormat;
import com.axibase.tsd.model.data.command.SimpleAggregateMatcher;
import com.axibase.tsd.model.data.series.Interval;
import com.axibase.tsd.model.data.series.Join;
import com.axibase.tsd.model.data.series.Rate;
import com.axibase.tsd.model.data.series.SeriesType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetSeriesQuery {
    @JsonProperty(value="entity")
    private final String entityName;
    @JsonProperty(value="metric")
    private final String metricName;
    private Long startTime = null;
    private Long endTime = null;
    private String startDate;
    private String endDate;
    private Interval interval;
    private Integer limit;
    private Boolean cache;
    private MultivaluedMap<String, String> tags = new MultivaluedHashMap();
    private SeriesType type;
    private Join join;
    private Rate rate;
    @JsonProperty(value="aggregate")
    private SimpleAggregateMatcher aggregateMatcher;
    private String requestId;
    private TimeFormat timeFormat;

    public GetSeriesQuery(String entityName, String metricName) {
        this.entityName = entityName;
        this.metricName = metricName;
    }

    public GetSeriesQuery(String entityName, String metricName, MultivaluedMap<String, String> tags) {
        this.entityName = entityName;
        this.metricName = metricName;
        this.tags = tags;
    }

    public GetSeriesQuery(String entityName, String metricName, Map<String, String> tags) {
        this.entityName = entityName;
        this.metricName = metricName;
        this.tags = new MultivaluedHashMap(tags);
    }

    public GetSeriesQuery(String entityName, String metricName, Map<String, String> tags, long startTime, long endTime) {
        this(entityName, metricName, tags);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public GetSeriesQuery setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public GetSeriesQuery setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public GetSeriesQuery setStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public GetSeriesQuery setEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public GetSeriesQuery setInterval(Interval interval) {
        this.interval = interval;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public GetSeriesQuery setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public GetSeriesQuery setCache(Boolean cache) {
        this.cache = cache;
        return this;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public MultivaluedMap<String, String> getTags() {
        return this.tags;
    }

    public GetSeriesQuery setTags(MultivaluedMap<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public SeriesType getType() {
        return this.type;
    }

    public GetSeriesQuery setType(SeriesType type) {
        this.type = type;
        return this;
    }

    public Join getJoin() {
        return this.join;
    }

    public GetSeriesQuery setJoin(Join join) {
        this.join = join;
        return this;
    }

    public Rate getRate() {
        return this.rate;
    }

    public GetSeriesQuery setRate(Rate rate) {
        this.rate = rate;
        return this;
    }

    public SimpleAggregateMatcher getAggregateMatcher() {
        return this.aggregateMatcher;
    }

    public GetSeriesQuery setAggregateMatcher(SimpleAggregateMatcher aggregateMatcher) {
        this.aggregateMatcher = aggregateMatcher;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public GetSeriesQuery setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public GetSeriesQuery setTimeFormat(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    public String toString() {
        return "GetSeriesQuery{startTime=" + this.startTime + ", endTime=" + this.endTime + ", startDate='" + this.startDate + '\'' + ", endDate='" + this.endDate + '\'' + ", interval='" + this.interval + '\'' + ", limit=" + this.limit + ", cache=" + this.cache + ", entityName='" + this.entityName + '\'' + ", metricName='" + this.metricName + '\'' + ", tags=" + this.tags + ", type=" + (Object)((Object)this.type) + ", join=" + this.join + ", rate=" + this.rate + ", aggregateMatcher=" + this.aggregateMatcher + ", requestId='" + this.requestId + '\'' + ", timeFormat=" + (Object)((Object)this.timeFormat) + '}';
    }
}

