/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.util;

import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AtsdUtil {
    public static final String JSON = "application/json";
    public static final String ADD_COMMAND = "add";
    public static final String DELETE_COMMAND = "delete";
    public static final String MARKER_KEYWORD = "marker ";
    public static final String PING_COMMAND = "ping\n";

    public static Map<String, String> toMap(String ... tagNamesAndValues) {
        if (ArrayUtils.isEmpty((Object[])tagNamesAndValues)) {
            return Collections.emptyMap();
        }
        if (tagNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Key without value");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < tagNamesAndValues.length; ++i) {
            result.put(tagNamesAndValues[i], tagNamesAndValues[++i]);
        }
        return result;
    }

    public static Map<String, Double> toValuesMap(Object ... metricNamesAndValues) {
        if (ArrayUtils.isEmpty((Object[])metricNamesAndValues)) {
            return Collections.emptyMap();
        }
        if (metricNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("Key without value");
        }
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < metricNamesAndValues.length; ++i) {
            result.put((String)metricNamesAndValues[i], (Double)metricNamesAndValues[++i]);
        }
        return result;
    }

    public static void check(String value, String errorMessage) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void checkPropertyTypeIsEmpty(String type) {
        AtsdUtil.check(type, "Type is empty");
    }

    public static void checkEntityIsEmpty(String entityName) {
        AtsdUtil.check(entityName, "Entity name is empty");
    }

    public static void checkEntityGroupIsEmpty(String entityGroupName) {
        AtsdUtil.check(entityGroupName, "Entity group name is empty");
    }

    public static void checkMetricIsEmpty(String metricName) {
        AtsdUtil.check(metricName, "Metric name is empty");
    }

    public static String formatMetricValue(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        return Double.toString(value);
    }

    public static class DateTime {
        public static final String MIN_QUERIED_DATE_TIME = "1000-01-01T00:00:00.000Z";
        public static final String MAX_QUERIED_DATE_TIME = "9999-12-31T23:59:59.999Z";

        public static Date parseDate(String date) {
            try {
                return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String isoFormat(Date date) {
            return DateTime.isoFormat(date, "GMT");
        }

        public static String isoFormat(Date date, String timeZoneName) {
            return DateTime.isoFormat(date, true, timeZoneName);
        }

        public static String isoFormat(Date date, boolean withMillis, String timeZoneName) {
            return ISO8601Utils.format((Date)date, (boolean)withMillis, (TimeZone)TimeZone.getTimeZone(timeZoneName));
        }
    }
}

