/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.query;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.query.Query;
import com.axibase.tsd.query.QueryParam;
import com.axibase.tsd.query.QueryPart;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractQueryPart<T>
implements QueryPart<T> {
    @Override
    public QueryPart<T> param(String name, Object value) {
        if (value != null) {
            return new QueryParam(name, value, this);
        }
        return this;
    }

    @Override
    public QueryPart<T> path(String path) {
        return this.path(path, false);
    }

    @Override
    public QueryPart<T> path(String path, boolean encode) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("Path element is empty: " + path);
        }
        return new Query(encode ? AbstractQueryPart.encode(path) : path, this);
    }

    protected static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new AtsdClientException("Encode error", e);
        }
    }
}

