/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.model.system.ClientConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfigurationFactory {
    private static final Logger log = LoggerFactory.getLogger(ClientConfigurationFactory.class);
    private static final String DEFAULT_PROTOCOL = "http";
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 1000;
    private static final long DEFAULT_PING_TIMEOUT_MS = 600000L;
    private static final String DEFAULT_CLIENT_PROPERTIES_FILE_NAME = "classpath:/client.properties";
    private static final String AXIBASE_TSD_API_DOMAIN = "axibase.tsd.api";
    private static final String DEFAULT_API_PATH = "/api/v1";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private String protocol;
    private String serverName;
    private String serverPort;
    private String metadataPath;
    private String dataPath;
    private String username;
    private String password;
    private int connectTimeoutMillis;
    private int readTimeoutMillis;
    private long pingTimeoutMillis;
    private boolean ignoreSSLErrors;
    private boolean skipStreamingControl;
    private boolean enableGzipCompression;

    private ClientConfigurationFactory() {
    }

    public static ClientConfigurationFactory createInstance() {
        String clientPropertiesFileName = DEFAULT_CLIENT_PROPERTIES_FILE_NAME;
        String sysPropertiesFileName = System.getProperty("axibase.tsd.api.client.properties");
        if (StringUtils.isNotBlank((CharSequence)sysPropertiesFileName)) {
            clientPropertiesFileName = sysPropertiesFileName;
        }
        return ClientConfigurationFactory.createInstance(clientPropertiesFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientConfigurationFactory createInstance(String clientPropertiesFileName) {
        log.debug("Load client properties from file: {}", (Object)clientPropertiesFileName);
        Properties clientProperties = new Properties();
        InputStream stream = null;
        try {
            if (clientPropertiesFileName.startsWith(CLASSPATH_PREFIX)) {
                String resourcePath = clientPropertiesFileName.split(CLASSPATH_PREFIX)[1];
                log.info("Load properties from classpath: {}", (Object)resourcePath);
                stream = ClientConfigurationFactory.class.getResourceAsStream(resourcePath);
            } else {
                File file = new File(clientPropertiesFileName);
                log.info("Load properties from file: {}", (Object)file.getAbsolutePath());
                stream = new FileInputStream(file);
            }
            clientProperties.load(stream);
        }
        catch (Throwable e) {
            try {
                log.warn("Could not load client properties", e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        ClientConfigurationFactory configurationFactory = new ClientConfigurationFactory();
        configurationFactory.serverName = ClientConfigurationFactory.load("axibase.tsd.api.server.name", clientProperties, null);
        configurationFactory.serverPort = ClientConfigurationFactory.load("axibase.tsd.api.server.port", clientProperties, null);
        configurationFactory.username = ClientConfigurationFactory.load("axibase.tsd.api.username", clientProperties, null);
        configurationFactory.password = ClientConfigurationFactory.load("axibase.tsd.api.password", clientProperties, null);
        configurationFactory.metadataPath = ClientConfigurationFactory.load("axibase.tsd.api.metadata.path", clientProperties, DEFAULT_API_PATH);
        configurationFactory.dataPath = ClientConfigurationFactory.load("axibase.tsd.api.data.path", clientProperties, DEFAULT_API_PATH);
        configurationFactory.protocol = ClientConfigurationFactory.load("axibase.tsd.api.protocol", clientProperties, DEFAULT_PROTOCOL);
        configurationFactory.connectTimeoutMillis = ClientConfigurationFactory.loadInt("axibase.tsd.api.connection.timeout", clientProperties, 1000);
        configurationFactory.readTimeoutMillis = ClientConfigurationFactory.loadInt("axibase.tsd.api.read.timeout", clientProperties, 1000);
        configurationFactory.pingTimeoutMillis = ClientConfigurationFactory.loadLong("axibase.tsd.api.ping.timeout", clientProperties, 600000L);
        configurationFactory.ignoreSSLErrors = "true".equals(ClientConfigurationFactory.load("axibase.tsd.api.ssl.errors.ignore", clientProperties, "false").toLowerCase().trim());
        configurationFactory.skipStreamingControl = "true".equals(ClientConfigurationFactory.load("axibase.tsd.api.streaming.control.skip", clientProperties, "false").toLowerCase().trim());
        configurationFactory.enableGzipCompression = "true".equals(ClientConfigurationFactory.load("axibase.tsd.api.compression.gzip.enable", clientProperties, "false").toLowerCase().trim());
        return configurationFactory;
    }

    public ClientConfigurationFactory(String protocol, String serverName, String serverPort, String metadataPath, String dataPath, String username, String password, int connectTimeoutMillis, int readTimeoutMillis, long pingTimeoutMillis, boolean ignoreSSLErrors, boolean skipStreamingControl, boolean enableGzipCompression) {
        this.serverName = serverName;
        this.serverPort = serverPort;
        this.username = username;
        this.password = password;
        this.metadataPath = metadataPath;
        this.dataPath = dataPath;
        this.protocol = protocol;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.pingTimeoutMillis = pingTimeoutMillis;
        this.ignoreSSLErrors = ignoreSSLErrors;
        this.skipStreamingControl = skipStreamingControl;
        this.enableGzipCompression = enableGzipCompression;
    }

    public ClientConfigurationFactory(String protocol, String serverName, int serverPort, String metadataPath, String dataPath, String username, String password, int connectTimeoutMillis, int readTimeoutMillis, long pingTimeoutMillis, boolean ignoreSSLErrors, boolean skipStreamingControl, boolean enableGzipCompression) {
        this(protocol, serverName, Integer.toString(serverPort), metadataPath, dataPath, username, password, connectTimeoutMillis, readTimeoutMillis, pingTimeoutMillis, ignoreSSLErrors, skipStreamingControl, enableGzipCompression);
    }

    public ClientConfiguration createClientConfiguration() {
        ClientConfiguration clientConfiguration = new ClientConfiguration(this.buildMetaDataUrl(), this.buildTimeSeriesUrl(), this.username, this.password);
        clientConfiguration.setConnectTimeoutMillis(this.connectTimeoutMillis);
        clientConfiguration.setReadTimeoutMillis(this.readTimeoutMillis);
        clientConfiguration.setPingTimeoutMillis(this.pingTimeoutMillis);
        clientConfiguration.setIgnoreSSLErrors(this.ignoreSSLErrors);
        clientConfiguration.setSkipStreamingControl(this.skipStreamingControl);
        clientConfiguration.setEnableBatchCompression(this.enableGzipCompression);
        return clientConfiguration;
    }

    private String buildMetaDataUrl() {
        return this.protocol + "://" + this.serverName + ":" + this.serverPort + this.metadataPath;
    }

    private String buildTimeSeriesUrl() {
        return this.protocol + "://" + this.serverName + ":" + this.serverPort + this.dataPath;
    }

    private static int loadInt(String name, Properties clientProperties, int defaultValue) {
        return NumberUtils.toInt((String)ClientConfigurationFactory.load(name, clientProperties, ""), (int)defaultValue);
    }

    private static long loadLong(String name, Properties clientProperties, long defaultValue) {
        return NumberUtils.toLong((String)ClientConfigurationFactory.load(name, clientProperties, ""), (long)defaultValue);
    }

    private static String load(String name, Properties clientProperties, String defaultValue) {
        String value = System.getProperty(name);
        if (value == null && (value = clientProperties.getProperty(name)) == null) {
            if (defaultValue == null) {
                log.error("Could not find required property: {}", (Object)name);
                throw new IllegalStateException(name + " property is null");
            }
            value = defaultValue;
        }
        return value;
    }
}

