/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
public class GZipWriterInterceptor
implements WriterInterceptor {
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        String acceptEncodings = this.getAcceptEncodingHeader((MultivaluedMap<String, Object>)context.getHeaders());
        if (acceptEncodings.contains("gzip")) {
            OutputStream outputStream = context.getOutputStream();
            context.setOutputStream((OutputStream)new GZIPOutputStream(outputStream));
        }
        context.proceed();
    }

    private String getAcceptEncodingHeader(MultivaluedMap<String, Object> headers) {
        Object value = headers.getFirst((Object)"Accept-Encoding");
        return value == null ? "" : (String)value;
    }
}

