/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.example;

import com.axibase.tsd.example.AbstractAtsdClientExample;
import com.axibase.tsd.model.data.command.GetSeriesQuery;
import com.axibase.tsd.model.data.series.Sample;
import com.axibase.tsd.model.data.series.Series;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ExportCsvExample
extends AbstractAtsdClientExample {
    public static void main(String[] args) throws Exception {
        ExportCsvExample example = new ExportCsvExample();
        example.configure();
        example.downloadAndSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadAndSave() throws IOException {
        String datePattern = "yyyy-MM-dd HH:mm:ss.SSS";
        String numberPattern = "###.000";
        String filePath = "/tmp/atsd/export.csv";
        String entityName = "atsd";
        String metricName = "jvm_memory_free";
        long startTime = System.currentTimeMillis() - 36000L;
        long endTime = System.currentTimeMillis();
        HashMap<String, String> tags = new HashMap<String, String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        DecimalFormat numberFormat = new DecimalFormat("###.000");
        GetSeriesQuery command = new GetSeriesQuery("atsd", "jvm_memory_free", tags, startTime, endTime);
        List<Series> seriesResultList = this.dataService.retrieveSeries(command);
        FileOutputStream outputStream = FileUtils.openOutputStream((File)new File("/tmp/atsd/export.csv"));
        PrintWriter writer = new PrintWriter(outputStream);
        try {
            for (int i = 0; i < seriesResultList.size(); ++i) {
                Series seriesResult = seriesResultList.get(i);
                this.logger.info("Time series key [" + i + "]: " + seriesResult.getTimeSeriesKey());
            }
            if (seriesResultList.size() != 1) {
                throw new IllegalArgumentException("Select the other parameters (entity, metric, tags) to export single time series key");
            }
            List<Sample> sampleList = seriesResultList.get(0).getData();
            for (Sample sample : sampleList) {
                Date date = new Date(sample.getTimeMillis());
                double value = sample.getNumericValue();
                writer.println(dateFormat.format(date) + "," + numberFormat.format(value));
            }
            this.logger.info("Saved " + sampleList.size() + " values");
            writer.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((Writer)writer);
        }
    }
}

