/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.network;

import com.axibase.tsd.model.data.series.Sample;
import com.axibase.tsd.network.AbstractInsertCommand;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class InsertCommand
extends AbstractInsertCommand {
    public static final String SERIES_COMMAND = "series";
    private final String metricName;
    private final Sample sample;

    public InsertCommand(String entityName, String metricName, Sample sample, Map<String, String> tags) {
        super(SERIES_COMMAND, entityName, sample.getTimeMillis(), tags);
        AtsdUtil.checkMetricIsEmpty(metricName);
        this.metricName = metricName;
        this.sample = sample;
    }

    public InsertCommand(String entityName, String metricName, Sample sample) {
        this(entityName, metricName, sample, Collections.emptyMap());
    }

    public InsertCommand(String entityName, String metricName, Sample sample, String ... tagNamesAndValues) {
        this(entityName, metricName, sample, AtsdUtil.toMap(tagNamesAndValues));
    }

    @Override
    protected void appendValues(StringBuilder sb) {
        sb.append(" m:").append(InsertCommand.handleName(this.metricName)).append('=').append(AtsdUtil.formatMetricValue(this.sample.getNumericValue()));
        if (StringUtils.isNotEmpty((CharSequence)this.sample.getTextValue())) {
            sb.append(" x:").append(InsertCommand.handleName(this.metricName)).append('=').append(InsertCommand.handleStringValue(this.sample.getTextValue()));
        }
    }
}

