/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.network;

import com.axibase.tsd.network.AbstractInsertCommand;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Collections;
import java.util.Map;

public class PropertyInsertCommand
extends AbstractInsertCommand {
    public static final String PROPERTY_COMMAND = "property";
    private final String typeName;
    private final Map<String, String> keys;
    private final Map<String, String> values;

    public PropertyInsertCommand(String entityName, String typeName, Long timeMillis, Map<String, String> keys, Map<String, String> values) {
        super(PROPERTY_COMMAND, entityName, timeMillis, Collections.emptyMap());
        AtsdUtil.checkPropertyTypeIsEmpty(typeName);
        this.typeName = typeName;
        this.keys = keys == null ? Collections.emptyMap() : keys;
        this.values = values == null ? Collections.emptyMap() : values;
    }

    @Override
    protected void appendValues(StringBuilder sb) {
        sb.append(" t:").append(this.typeName);
        PropertyInsertCommand.appendKeysAndValues(sb, " k:", this.keys);
        PropertyInsertCommand.appendKeysAndValues(sb, " v:", this.values);
    }
}

