/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.series;

import com.axibase.tsd.util.AtsdUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Sample {
    @JsonProperty(value="t")
    private Long timeMillis;
    @JsonProperty(value="d")
    private String date;
    @JsonProperty(value="v")
    private double numericValue;
    @JsonProperty(value="x")
    private String textValue;

    public Sample() {
    }

    public Sample(long timeMillis, double value) {
        this.setTimeMillis(timeMillis);
        this.setNumericValue(value);
    }

    public Sample(long timeMillis, double numericValue, String textValue) {
        this.setTimeMillis(timeMillis);
        this.setNumericValue(numericValue);
        if (StringUtils.isNotEmpty((CharSequence)textValue)) {
            this.setTextValue(textValue);
        }
    }

    public Long getTimeMillis() {
        return this.timeMillis;
    }

    public void setTimeMillis(Long timeMillis) {
        if (this.date == null) {
            this.date = AtsdUtil.DateTime.isoFormat(new Date(timeMillis));
        }
        this.timeMillis = timeMillis;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        if (this.timeMillis == null) {
            this.timeMillis = AtsdUtil.DateTime.parseDate(date).getTime();
        }
        this.date = date;
    }

    @JsonIgnore
    @Deprecated
    public double getValue() {
        return this.numericValue;
    }

    @Deprecated
    public void setValue(double value) {
        this.numericValue = value;
    }

    public double getNumericValue() {
        return this.numericValue;
    }

    public void setNumericValue(double value) {
        this.numericValue = value;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void setTextValue(String value) {
        this.textValue = value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)obj;
        if (Double.isNaN(this.numericValue) && !Double.isNaN(other.numericValue) || this.numericValue != other.numericValue) {
            return false;
        }
        return this.textValue == null ? other.textValue == null : this.textValue.equals(other.textValue);
    }

    public String toString() {
        return "Sample{timeMillis=" + this.timeMillis + ", date='" + this.date + '\'' + ", numericValue=" + this.numericValue + ", textValue='" + this.textValue + '\'' + '}';
    }
}

