/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.command;

import com.axibase.tsd.model.data.TimeFormat;
import com.axibase.tsd.util.AtsdUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetPropertiesQuery {
    @JsonProperty(value="entity")
    private final String entityName;
    private final String type;
    private Long startTime = null;
    private Long endTime = null;
    private String limit;
    private boolean last;
    private Map<String, String> key;
    private String keyExpression;
    private TimeFormat timeFormat;

    public GetPropertiesQuery(String type, String entityName, Date startDateTime, Date endDateTime) {
        this.entityName = entityName;
        this.type = type;
        this.setStartTime(startDateTime.getTime());
        this.setEndTime(endDateTime.getTime());
    }

    public GetPropertiesQuery(String type, String entityName) {
        this(type, entityName, AtsdUtil.DateTime.parseDate("1000-01-01T00:00:00.000Z"), AtsdUtil.DateTime.parseDate("9999-12-31T23:59:59.999Z"));
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getType() {
        return this.type;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public String getLimit() {
        return this.limit;
    }

    public boolean isLast() {
        return this.last;
    }

    public Map<String, String> getKey() {
        return this.key;
    }

    public String getKeyExpression() {
        return this.keyExpression;
    }

    public TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    public GetPropertiesQuery setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public GetPropertiesQuery setEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public GetPropertiesQuery setLimit(String limit) {
        this.limit = limit;
        return this;
    }

    public GetPropertiesQuery setLast(boolean last) {
        this.last = last;
        return this;
    }

    public GetPropertiesQuery setKey(Map<String, String> key) {
        this.key = key;
        return this;
    }

    public GetPropertiesQuery setKeyExpression(String keyExpression) {
        this.keyExpression = keyExpression;
        return this;
    }

    public GetPropertiesQuery setTimeFormat(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
        return this;
    }

    public String toString() {
        return "GetPropertiesQuery{entityName='" + this.entityName + '\'' + ", type='" + this.type + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit='" + this.limit + '\'' + ", last=" + this.last + ", key=" + this.key + ", keyExpression='" + this.keyExpression + '\'' + ", timeFormat=" + (Object)((Object)this.timeFormat) + '}';
    }
}

