/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.network;

import com.axibase.tsd.network.PlainCommand;
import com.axibase.tsd.util.AtsdUtil;
import java.util.Collections;
import java.util.Map;

public abstract class AbstractInsertCommand
implements PlainCommand {
    private final String commandName;
    protected final String entityName;
    private final Long timeMillis;
    protected final Map<String, String> tags;

    public AbstractInsertCommand(String commandName, String entityName, Long timeMillis, Map<String, String> tags) {
        this.commandName = commandName;
        AtsdUtil.checkEntityIsEmpty(entityName);
        this.entityName = entityName;
        this.timeMillis = timeMillis;
        this.tags = tags == null ? Collections.emptyMap() : tags;
    }

    @Override
    public final String compose() {
        StringBuilder sb = new StringBuilder(this.commandName).append(' ').append("e:").append(this.entityName);
        if (this.timeMillis != null) {
            sb.append(' ').append("ms:").append(this.timeMillis);
        }
        AbstractInsertCommand.appendKeysAndValues(sb, " t:", this.tags);
        this.appendValues(sb);
        return sb.append('\n').toString();
    }

    protected static void appendKeysAndValues(StringBuilder sb, String prefix, Map<String, String> map) {
        for (Map.Entry<String, String> tagNameAndValue : map.entrySet()) {
            sb.append(prefix).append(tagNameAndValue.getKey()).append('=').append(AbstractInsertCommand.handleTagValue(tagNameAndValue.getValue()));
        }
    }

    private static String handleTagValue(String value) {
        if (value == null) {
            return "null";
        }
        return '\"' + value.replace("\"", "\"\"") + '\"';
    }

    protected abstract void appendValues(StringBuilder var1);
}

