/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.command;

import com.axibase.tsd.model.data.Severity;
import com.axibase.tsd.model.data.series.Interval;
import com.axibase.tsd.util.AtsdUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetMessagesQuery {
    private Interval interval;
    private Date startDate;
    private Date endDate;
    private String type;
    private String source;
    private Map<String, String> tags;
    private Severity severity;
    private List<Severity> severities;
    private Severity minSeverity;
    private String entity;
    private List<String> entities;
    private String entityGroup;
    private String entityExpression;

    public GetMessagesQuery(String entity) {
        this.setEntity(entity);
        this.setStartDate(AtsdUtil.DateTime.parseDate("1000-01-01T00:00:00.000Z"));
        this.setEndDate(AtsdUtil.DateTime.parseDate("9999-12-31T23:59:59.999Z"));
    }

    public GetMessagesQuery(List<String> entities) {
        this.setEntities(entities);
        this.setStartDate(AtsdUtil.DateTime.parseDate("1000-01-01T00:00:00.000Z"));
        this.setEndDate(AtsdUtil.DateTime.parseDate("9999-12-31T23:59:59.999Z"));
    }

    public Interval getInterval() {
        return this.interval;
    }

    public GetMessagesQuery setInterval(Interval interval) {
        this.interval = interval;
        return this;
    }

    public String getStartDate() {
        return AtsdUtil.DateTime.ISOFormat(this.startDate);
    }

    public GetMessagesQuery setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public String getEndDate() {
        return AtsdUtil.DateTime.ISOFormat(this.endDate);
    }

    public GetMessagesQuery setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public GetMessagesQuery setType(String type) {
        this.type = type;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public GetMessagesQuery setSource(String source) {
        this.source = source;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public GetMessagesQuery setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public GetMessagesQuery setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public List<Severity> getSeverities() {
        return this.severities;
    }

    public GetMessagesQuery setSeverities(List<Severity> severities) {
        this.severities = severities;
        return this;
    }

    public Severity getMinSeverity() {
        return this.minSeverity;
    }

    public GetMessagesQuery setMinSeverity(Severity minSeverity) {
        this.minSeverity = minSeverity;
        return this;
    }

    public String getEntity() {
        return this.entity;
    }

    public GetMessagesQuery setEntity(String entity) {
        this.entity = entity;
        return this;
    }

    public List<String> getEntities() {
        return this.entities;
    }

    public GetMessagesQuery setEntities(List<String> entities) {
        this.entities = entities;
        return this;
    }

    public String getEntityGroup() {
        return this.entityGroup;
    }

    public GetMessagesQuery setEntityGroup(String entityGroup) {
        this.entityGroup = entityGroup;
        return this;
    }

    public String getEntityExpression() {
        return this.entityExpression;
    }

    public GetMessagesQuery setEntityExpression(String entityExpression) {
        this.entityExpression = entityExpression;
        return this;
    }
}

