/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.client.AtsdServerException;
import com.axibase.tsd.client.AtsdTrustManager;
import com.axibase.tsd.client.RequestBodyLogger;
import com.axibase.tsd.client.RequestProcessor;
import com.axibase.tsd.model.system.ClientConfiguration;
import com.axibase.tsd.model.system.ServerError;
import com.axibase.tsd.query.QueryPart;
import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.commons.io.IOUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.filter.LoggingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private static final java.util.logging.Logger legacyLogger = java.util.logging.Logger.getLogger(HttpClient.class.getName());
    public static final int HTTP_STATUS_OK = 200;
    public static final int HTTP_STATUS_FAIL = 400;
    public static final int HTTP_STATUS_NOT_FOUND = 404;
    private ClientConfiguration clientConfiguration;
    private final Client client;

    HttpClient(ClientConfiguration clientConfiguration) {
        this.client = HttpClient.buildClient(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
    }

    private static Client buildClient(ClientConfiguration clientConfiguration) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register(JsonMappingExceptionMapper.class).register(JsonParseExceptionMapper.class).register(JacksonJaxbJsonProvider.class, new Class[]{MessageBodyReader.class, MessageBodyWriter.class}).register(RequestBodyLogger.class).register((Object)HttpAuthenticationFeature.basic((String)clientConfiguration.getUsername(), (String)clientConfiguration.getPassword()));
        if (log.isDebugEnabled()) {
            clientConfig.register((Object)new LoggingFilter(legacyLogger, true));
        }
        HttpClient.configureHttps(clientConfiguration, clientConfig);
        clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        Client builtClient = ClientBuilder.newBuilder().withConfig((Configuration)clientConfig).build();
        builtClient.property("jersey.config.client.connectTimeout", (Object)clientConfiguration.getConnectTimeoutMillis());
        builtClient.property("jersey.config.client.readTimeout", (Object)clientConfiguration.getReadTimeoutMillis());
        return builtClient;
    }

    private static void configureHttps(ClientConfiguration clientConfiguration, ClientConfig clientConfig) {
        SslConfigurator sslConfig = SslConfigurator.newInstance().securityProtocol("SSL");
        PoolingHttpClientConnectionManager connectionManager = HttpClient.createConnectionManager(clientConfiguration, sslConfig);
        clientConfig.property("jersey.config.apache.client.connectionManager", (Object)connectionManager);
        clientConfig.property("jersey.config.apache.client.ssl.sslConfig", (Object)sslConfig);
    }

    public static PoolingHttpClientConnectionManager createConnectionManager(ClientConfiguration clientConfiguration, SslConfigurator sslConfig) {
        StrictHostnameVerifier hostnameVerifier;
        SSLContext sslContext = sslConfig.createSSLContext();
        if (clientConfiguration.isIgnoreSSLErrors()) {
            HttpClient.ignoreSslCertificateErrorInit(sslContext);
            hostnameVerifier = new AllowAllHostnameVerifier();
        } else {
            hostnameVerifier = new StrictHostnameVerifier();
        }
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)hostnameVerifier);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        return new PoolingHttpClientConnectionManager(registry);
    }

    private static void ignoreSslCertificateErrorInit(SSLContext sslContext) {
        try {
            sslContext.init(null, new TrustManager[]{new AtsdTrustManager()}, new SecureRandom());
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.warn("SSL context initialization error: ", (Throwable)e);
        }
    }

    public <T> List<T> requestMetaDataList(Class<T> clazz, QueryPart<T> query) {
        return this.requestList(this.clientConfiguration.getMetadataUrl(), clazz, query, null);
    }

    public <T> T requestMetaDataObject(Class<T> clazz, QueryPart<T> query) {
        return this.requestObject(this.clientConfiguration.getMetadataUrl(), clazz, query, null);
    }

    public <E> boolean updateMetaData(QueryPart query, RequestProcessor<E> requestProcessor) {
        return this.update(this.clientConfiguration.getMetadataUrl(), query, requestProcessor);
    }

    public <E> boolean updateData(QueryPart query, RequestProcessor<E> requestProcessor) {
        return this.update(this.clientConfiguration.getDataUrl(), query, requestProcessor);
    }

    public boolean updateData(QueryPart query, String data) {
        return this.update(this.clientConfiguration.getDataUrl(), query, RequestProcessor.post(data), "text/plain");
    }

    public <T, E> List<T> requestDataList(Class<T> clazz, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        String url = this.clientConfiguration.getDataUrl();
        return this.requestList(url, clazz, query, requestProcessor);
    }

    public <T, E> T requestData(Class<T> clazz, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        String url = this.clientConfiguration.getDataUrl();
        return this.requestObject(url, clazz, query, requestProcessor);
    }

    private <T, E> List<T> requestList(String url, Class<T> resultClass, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        Response response = this.doRequest(url, query, requestProcessor);
        if (response.getStatus() == 200) {
            return (List)response.readEntity(this.listType(resultClass));
        }
        if (response.getStatus() == 404) {
            return Collections.emptyList();
        }
        throw this.buildException(response);
    }

    private <T, E> T requestObject(String url, Class<T> resultClass, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        Response response = this.doRequest(url, query, requestProcessor);
        if (response.getStatus() == 200) {
            return (T)response.readEntity(resultClass);
        }
        if (response.getStatus() == 404) {
            this.buildAndLogServerError(response);
            return null;
        }
        throw this.buildException(response);
    }

    public InputStream requestInputStream(QueryPart query, RequestProcessor requestProcessor) {
        String url = this.clientConfiguration.getDataUrl();
        Response response = this.doRequest(url, query, requestProcessor);
        Object entity = response.getEntity();
        if (response.getStatus() == 200 && entity instanceof InputStream) {
            return (InputStream)entity;
        }
        throw this.buildException(response);
    }

    private <E> boolean update(String url, QueryPart query, RequestProcessor<E> requestProcessor) {
        Response response = this.doRequest(url, query, requestProcessor);
        HttpClient.fixApacheHttpClientBlocking(response);
        if (response.getStatus() == 200) {
            return true;
        }
        if (response.getStatus() == 400) {
            return false;
        }
        throw this.buildException(response);
    }

    private <E> boolean update(String url, QueryPart query, RequestProcessor<E> requestProcessor, String mediaType) {
        Response response = this.doRequest(url, query, requestProcessor, mediaType);
        HttpClient.fixApacheHttpClientBlocking(response);
        if (response.getStatus() == 200) {
            return true;
        }
        if (response.getStatus() == 400) {
            return false;
        }
        throw this.buildException(response);
    }

    private AtsdServerException buildException(Response response) {
        ServerError serverError = this.buildAndLogServerError(response);
        return new AtsdServerException(response.getStatusInfo().getReasonPhrase() + " (" + response.getStatus() + ")" + (serverError == null ? "" : ", " + serverError.getMessage()));
    }

    private ServerError buildAndLogServerError(Response response) {
        ServerError serverError = null;
        try {
            serverError = (ServerError)response.readEntity(ServerError.class);
            log.warn("Server error: {}", (Object)serverError);
        }
        catch (Throwable e) {
            log.warn("Couldn't read error message", e);
        }
        return serverError;
    }

    private <T, E> Response doRequest(String url, QueryPart<T> query, RequestProcessor<E> requestProcessor) {
        return this.doRequest(url, query, requestProcessor, "application/json");
    }

    private <T, E> Response doRequest(String url, QueryPart<T> query, RequestProcessor<E> requestProcessor, String mediaType) {
        WebTarget target = this.client.target(url);
        target = query.fill(target);
        log.debug("url = {}", (Object)target.getUri());
        Invocation.Builder request = target.request(new String[]{mediaType});
        Response response = null;
        try {
            response = requestProcessor == null ? request.get() : requestProcessor.process(request, mediaType);
        }
        catch (Throwable e) {
            throw new AtsdClientException("Error while processing the request", e);
        }
        return response;
    }

    private <T> GenericType<List<T>> listType(final Class<T> clazz) {
        ParameterizedType genericType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{clazz};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return List.class;
            }
        };
        return new GenericType<List<T>>(genericType){};
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private static void fixApacheHttpClientBlocking(Response response) {
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            IOUtils.closeQuietly((InputStream)((InputStream)entity));
        }
    }
}

