/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.HttpClientManager;
import com.axibase.tsd.client.RequestProcessor;
import com.axibase.tsd.model.meta.Entity;
import com.axibase.tsd.model.meta.EntityAndTags;
import com.axibase.tsd.model.meta.EntityGroup;
import com.axibase.tsd.model.meta.Metric;
import com.axibase.tsd.model.meta.TagAppender;
import com.axibase.tsd.query.Query;
import com.axibase.tsd.query.QueryPart;
import com.axibase.tsd.util.AtsdUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MetaDataService {
    private HttpClientManager httpClientManager;

    public MetaDataService() {
    }

    public MetaDataService(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public void setHttpClientManager(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public List<Metric> retrieveMetrics(Boolean active, String expression, TagAppender tagAppender, Integer limit) {
        QueryPart query = new Query("metrics").param("active", active).param("expression", expression).param("limit", limit);
        if (tagAppender != null) {
            query = query.param("tags", tagAppender.getTags());
        }
        return this.httpClientManager.requestMetaDataList(Metric.class, query);
    }

    public List<Metric> retrieveMetrics(String entityName, Boolean active, String expression, TagAppender tagAppender, Integer limit) {
        QueryPart query = new Query("entities").path(entityName).path("metrics").param("active", active).param("expression", expression).param("limit", limit);
        if (tagAppender != null) {
            query = query.param("tags", tagAppender.getTags());
        }
        return this.httpClientManager.requestMetaDataList(Metric.class, query);
    }

    public Metric retrieveMetric(String metricName) {
        AtsdUtil.checkMetricIsEmpty(metricName);
        return this.httpClientManager.requestMetaDataObject(Metric.class, new Query("metrics").path(metricName));
    }

    public boolean createOrReplaceMetric(Metric metric) {
        String metricName = metric.getName();
        AtsdUtil.checkMetricIsEmpty(metricName);
        QueryPart queryPart = new Query("metrics").path(metricName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.put(metric));
    }

    public boolean updateMetric(Metric metric) {
        String metricName = metric.getName();
        AtsdUtil.checkMetricIsEmpty(metricName);
        QueryPart queryPart = new Query("metrics").path(metricName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.patch(metric));
    }

    public boolean deleteMetric(Metric metric) {
        String metricName = metric.getName();
        AtsdUtil.checkMetricIsEmpty(metricName);
        QueryPart queryPart = new Query("metrics").path(metricName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.delete());
    }

    public List<Entity> retrieveEntities(Boolean active, String expression, TagAppender tagAppender, Integer limit) {
        QueryPart query = new Query("entities").param("active", active).param("expression", expression).param("limit", limit);
        if (tagAppender != null) {
            query = query.param("tags", tagAppender.getTags());
        }
        return this.httpClientManager.requestMetaDataList(Entity.class, query);
    }

    public Entity retrieveEntity(String entityName) {
        AtsdUtil.checkEntityIsEmpty(entityName);
        QueryPart query = new Query("entities").path(entityName);
        return this.httpClientManager.requestMetaDataObject(Entity.class, query);
    }

    public Set<String> retrievePropertyTypes(String entityName, Long startTime) {
        AtsdUtil.checkEntityIsEmpty(entityName);
        QueryPart query = new Query("entities");
        query = query.path(entityName).path("property-types").param("startTime", startTime);
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.httpClientManager.requestDataList(String.class, query, null));
        return result;
    }

    public boolean createOrReplaceEntity(Entity entity) {
        String entityName = entity.getName();
        AtsdUtil.checkEntityIsEmpty(entityName);
        QueryPart queryPart = new Query("entities").path(entityName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.put(entity));
    }

    public boolean updateEntity(Entity entity) {
        String entityName = entity.getName();
        AtsdUtil.checkEntityIsEmpty(entityName);
        QueryPart queryPart = new Query("entities").path(entityName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.patch(entity));
    }

    public boolean deleteEntity(Entity entity) {
        String entityName = entity.getName();
        AtsdUtil.checkEntityIsEmpty(entityName);
        QueryPart queryPart = new Query("entities").path(entityName);
        return this.httpClientManager.updateMetaData(queryPart, RequestProcessor.delete());
    }

    public List<EntityAndTags> retrieveEntityAndTags(String metricName, String entityName) {
        AtsdUtil.checkMetricIsEmpty(metricName);
        return this.httpClientManager.requestMetaDataList(EntityAndTags.class, new Query("metrics").path(metricName).path("entity-and-tags").param("entity", entityName));
    }

    public List<EntityGroup> retrieveEntityGroups() {
        return this.httpClientManager.requestMetaDataList(EntityGroup.class, new Query("entity-groups"));
    }

    public EntityGroup retrieveEntityGroup(String entityGroupName) {
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName);
        return this.httpClientManager.requestMetaDataObject(EntityGroup.class, query);
    }

    public boolean createOrReplaceEntityGroup(EntityGroup entityGroup) {
        String entityGroupName = entityGroup.getName();
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName);
        return this.httpClientManager.updateMetaData(query, RequestProcessor.put(entityGroup));
    }

    public boolean updateEntityGroup(EntityGroup entityGroup) {
        String entityGroupName = entityGroup.getName();
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName);
        return this.httpClientManager.updateMetaData(query, RequestProcessor.patch(entityGroup));
    }

    public boolean deleteEntityGroup(EntityGroup entityGroup) {
        String entityGroupName = entityGroup.getName();
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName);
        return this.httpClientManager.updateMetaData(query, RequestProcessor.delete());
    }

    public List<Entity> retrieveGroupEntities(String entityGroupName, Boolean active, String expression, TagAppender tagAppender, Integer limit) {
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities").param("active", active).param("expression", expression).param("limit", limit);
        if (tagAppender != null) {
            query = query.param("tags", tagAppender.getTags());
        }
        return this.httpClientManager.requestMetaDataList(Entity.class, query);
    }

    public List<Entity> retrieveGroupEntities(String entityGroupName) {
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities");
        query = query.param("tags", TagAppender.ALL.getTags());
        return this.httpClientManager.requestMetaDataList(Entity.class, query);
    }

    public boolean addGroupEntities(String entityGroupName, Boolean createEntities, Entity ... entities) {
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        ArrayList<String> entitiesNames = new ArrayList<String>();
        for (Entity entity : entities) {
            entitiesNames.add(entity.getName());
        }
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities/add").param("createEntities", createEntities);
        return this.httpClientManager.updateData(query, RequestProcessor.post(entitiesNames));
    }

    public boolean replaceGroupEntities(String entityGroupName, Boolean createEntities, Entity ... entities) {
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        ArrayList<String> entitiesNames = new ArrayList<String>();
        for (Entity entity : entities) {
            entitiesNames.add(entity.getName());
        }
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities/set").param("createEntities", createEntities);
        return this.httpClientManager.updateMetaData(query, RequestProcessor.post(entitiesNames));
    }

    public boolean deleteGroupEntities(String entityGroupName, Entity ... entities) {
        AtsdUtil.checkEntityGroupIsEmpty(entityGroupName);
        ArrayList<String> entitiesNames = new ArrayList<String>();
        for (Entity entity : entities) {
            entitiesNames.add(entity.getName());
        }
        QueryPart query = new Query("entity-groups").path(entityGroupName).path("entities/delete");
        return this.httpClientManager.updateMetaData(query, RequestProcessor.post(entitiesNames));
    }

    public boolean deleteAllGroupEntities(String entityGroupName) {
        return this.replaceGroupEntities(entityGroupName, true, new Entity[0]);
    }
}

