/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.model.data.series;

import com.axibase.tsd.util.AtsdUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Sample {
    @JsonProperty(value="t")
    private Long timeMillis;
    @JsonProperty(value="d")
    private String date;
    @JsonProperty(value="v")
    private double value;

    public Sample() {
    }

    public Sample(long timeMillis, double value) {
        this.setTimeMillis(timeMillis);
        this.setValue(value);
    }

    public Long getTimeMillis() {
        return this.timeMillis;
    }

    public void setTimeMillis(Long timeMillis) {
        if (this.date == null) {
            this.date = AtsdUtil.DateTime.isoFormat(new Date(timeMillis));
        }
        this.timeMillis = timeMillis;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        if (this.timeMillis == null) {
            this.timeMillis = AtsdUtil.DateTime.parseDate(date).getTime();
        }
        this.date = date;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Sample other = (Sample)obj;
        return this.getValue() == other.getValue();
    }

    public String toString() {
        return "Sample{timeMillis=" + this.timeMillis + ", date='" + this.date + '\'' + ", value=" + this.value + '}';
    }
}

