/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.model.system.TcpClientConfiguration;
import com.axibase.tsd.network.PlainCommand;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpClient {
    private static final Logger log = LoggerFactory.getLogger(TcpClient.class);
    private final String serverName;
    private final int port;
    private final boolean autoflush;
    private final int connectionTimeoutMs;
    private final int readTimeoutMs;
    private Socket socket;
    private OutputStreamWriter writer;
    private final int BUFFER_SIZE = 16384;

    TcpClient(TcpClientConfiguration clientConfiguration) {
        this.serverName = clientConfiguration.getServerName();
        this.port = clientConfiguration.getPort();
        this.autoflush = clientConfiguration.isAutoflush();
        this.connectionTimeoutMs = clientConfiguration.getConnectionTimeoutMs();
        this.readTimeoutMs = clientConfiguration.getReadTimeoutMs();
    }

    public synchronized void send(PlainCommand command) {
        this.send(command.compose());
    }

    public synchronized void send(Collection<PlainCommand> commands) {
        if (this.autoflush) {
            for (PlainCommand command : commands) {
                this.send(command);
            }
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (PlainCommand command : commands) {
            String rawCommand = command.compose();
            builder.append(rawCommand);
            if (rawCommand.endsWith("\n")) continue;
            builder.append("\n");
        }
        this.send(builder.toString());
    }

    private void send(String data) {
        if (this.socket == null) {
            try {
                log.info("Connecting to ATSD at {}:{}", (Object)this.serverName, (Object)this.port);
                this.socket = this.recreateSocket();
                this.writer = this.recreateWriter(this.socket);
            }
            catch (IOException e) {
                throw new AtsdClientException(String.format("Error while connecting to ATSD at %s:%s", this.serverName, this.port), e);
            }
        }
        try {
            this.writeData(data);
            return;
        }
        catch (Exception e) {
            log.warn("Error while sending commands to ATSD at {}:{}. Trying to reconnect", new Object[]{this.serverName, this.port, e});
            try {
                this.socket = this.recreateSocket();
                this.writer = this.recreateWriter(this.socket);
                this.writeData(data);
            }
            catch (Exception e2) {
                throw new AtsdClientException(String.format("Error while sending command to ATSD at %s:%s", this.serverName, this.port), e2);
            }
            return;
        }
    }

    private void writeData(String data) throws IOException {
        this.writer.write(data);
        if (!data.endsWith("\n")) {
            this.writer.write(10);
        }
        this.writer.flush();
    }

    public synchronized void close() {
        this.closeWriter();
        this.closeSocket();
    }

    private void closeWriter() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                log.warn("Error while closing tcp stream {}:{}", new Object[]{this.serverName, this.port, e});
            }
            this.writer = null;
        }
    }

    private void closeSocket() {
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    log.warn("Error while closing tcp stream {}:{}", new Object[]{this.serverName, this.port, e});
                }
            }
            this.socket = null;
        }
    }

    private Socket recreateSocket() throws IOException {
        this.close();
        Socket socket = new Socket();
        socket.setSoTimeout(this.readTimeoutMs);
        socket.connect(new InetSocketAddress(this.serverName, this.port), this.connectionTimeoutMs);
        return socket;
    }

    private OutputStreamWriter recreateWriter(Socket socket) throws IOException {
        this.closeWriter();
        BufferedOutputStream stream = new BufferedOutputStream(socket.getOutputStream(), 16384);
        return new OutputStreamWriter((OutputStream)stream, "UTF8");
    }
}

