/*
 * Decompiled with CFR 0.152.
 */
package com.axibase.tsd.client;

import com.axibase.tsd.client.AtsdClientException;
import com.axibase.tsd.client.AtsdServerException;
import com.axibase.tsd.client.HttpClient;
import com.axibase.tsd.client.HttpClientManager;
import com.axibase.tsd.client.RequestProcessor;
import com.axibase.tsd.client.ResponseDataExtractor;
import com.axibase.tsd.client.SeriesCommandPreparer;
import com.axibase.tsd.model.data.Alert;
import com.axibase.tsd.model.data.AlertHistory;
import com.axibase.tsd.model.data.Message;
import com.axibase.tsd.model.data.Property;
import com.axibase.tsd.model.data.TimeFormat;
import com.axibase.tsd.model.data.command.AddSeriesCommand;
import com.axibase.tsd.model.data.command.BatchAlertCommand;
import com.axibase.tsd.model.data.command.BatchQuery;
import com.axibase.tsd.model.data.command.BatchResponse;
import com.axibase.tsd.model.data.command.GetAlertHistoryQuery;
import com.axibase.tsd.model.data.command.GetAlertQuery;
import com.axibase.tsd.model.data.command.GetMessagesQuery;
import com.axibase.tsd.model.data.command.GetPropertiesQuery;
import com.axibase.tsd.model.data.command.GetSeriesQuery;
import com.axibase.tsd.model.data.command.SendCommandResult;
import com.axibase.tsd.model.data.filters.DeletePropertyFilter;
import com.axibase.tsd.model.data.series.Series;
import com.axibase.tsd.model.data.series.aggregate.AggregateType;
import com.axibase.tsd.model.system.Format;
import com.axibase.tsd.model.system.ServerError;
import com.axibase.tsd.network.PlainCommand;
import com.axibase.tsd.query.Query;
import com.axibase.tsd.query.QueryPart;
import com.axibase.tsd.util.AtsdUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class DataService {
    private static final SeriesCommandPreparer LAST_PREPARER = new LastPreparer();
    public static final String SERIES_KEYWORD = "series";
    public static final String INSERT_KEYWORD = "insert";
    private HttpClientManager httpClientManager;

    public DataService() {
    }

    public DataService(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public void setHttpClientManager(HttpClientManager httpClientManager) {
        this.httpClientManager = httpClientManager;
    }

    public List<Series> retrieveSeries(GetSeriesQuery ... seriesQueries) {
        Query query = new Query("series/query");
        return this.httpClientManager.requestDataList(Series.class, query, RequestProcessor.post(Arrays.asList(seriesQueries)));
    }

    public List<Series> retrieveSeries(SeriesCommandPreparer preparer, GetSeriesQuery ... seriesQueries) {
        if (preparer != null) {
            for (GetSeriesQuery seriesQuery : seriesQueries) {
                preparer.prepare(seriesQuery);
            }
        }
        return this.retrieveSeries(seriesQueries);
    }

    public boolean addSeries(AddSeriesCommand ... addSeriesCommands) {
        for (AddSeriesCommand addSeriesCommand : addSeriesCommands) {
            AtsdUtil.checkEntityIsEmpty(addSeriesCommand.getEntityName());
            AtsdUtil.checkMetricIsEmpty(addSeriesCommand.getMetricName());
        }
        QueryPart query = new Query(SERIES_KEYWORD).path(INSERT_KEYWORD);
        return this.httpClientManager.updateData(query, RequestProcessor.post(Arrays.asList(addSeriesCommands)));
    }

    public boolean addSeriesCsv(String entityName, String data, String ... tagNamesAndValues) {
        AtsdUtil.checkEntityIsEmpty(entityName);
        AtsdUtil.check(data, "Data is empty");
        QueryPart query = new Query(SERIES_KEYWORD).path("csv").path(entityName, true);
        if (tagNamesAndValues != null) {
            if (tagNamesAndValues.length % 2 == 1) {
                throw new IllegalArgumentException("Tag without value");
            }
            for (int i = 0; i < tagNamesAndValues.length; ++i) {
                query = query.param(tagNamesAndValues[i], tagNamesAndValues[++i]);
            }
        }
        return this.httpClientManager.updateData(query, data);
    }

    public List<Series> retrieveLastSeries(GetSeriesQuery ... seriesQueries) {
        return this.retrieveSeries(LAST_PREPARER, seriesQueries);
    }

    public InputStream querySeriesPack(Format format, String entityName, String metricName, Map<String, String> tags, long startTime, long endTime, String period, AggregateType aggregateType, Integer limit, Boolean last, String columns) {
        QueryPart seriesQuery = new Query(SERIES_KEYWORD).path(format.name().toLowerCase()).path(entityName, true).path(metricName, true).param("startTime", startTime).param("endTime", endTime).param("period", period).param("aggregate", aggregateType == null ? null : aggregateType.name().toLowerCase()).param("limit", limit).param("last", last).param("columns", columns);
        for (Map.Entry<String, String> tagAndValue : tags.entrySet()) {
            seriesQuery = seriesQuery.param("t:" + tagAndValue.getKey(), tagAndValue.getValue());
        }
        return this.httpClientManager.requestInputStream(seriesQuery, null);
    }

    public List<Property> retrieveProperties(GetPropertiesQuery ... getPropertiesQueries) {
        ArrayList queriesList = new ArrayList();
        Collections.addAll(queriesList, getPropertiesQueries);
        Query query = new Query("properties/query");
        return this.httpClientManager.requestDataList(Property.class, query, RequestProcessor.post(queriesList));
    }

    public List<Property> retrieveProperties(String entityName, String typeName) {
        AtsdUtil.checkEntityIsEmpty(entityName);
        AtsdUtil.checkPropertyTypeIsEmpty(typeName);
        QueryPart query = new Query("properties");
        query = query.path(entityName, true).path("types").path(typeName, true);
        return this.httpClientManager.requestDataList(Property.class, query, null);
    }

    public boolean insertProperties(Property ... properties) {
        for (Property property : properties) {
            AtsdUtil.checkEntityIsEmpty(property.getEntityName());
            AtsdUtil.checkPropertyTypeIsEmpty(property.getType());
        }
        QueryPart query = new Query("properties").path(INSERT_KEYWORD);
        return this.httpClientManager.updateData(query, RequestProcessor.post(Arrays.asList(properties)));
    }

    public List<Message> retrieveMessages(GetMessagesQuery ... getMessagesQueries) {
        Query query = new Query("messages/query");
        return this.httpClientManager.requestDataList(Message.class, query, RequestProcessor.post(Arrays.asList(getMessagesQueries)));
    }

    public boolean insertMessages(Message ... messages) {
        for (Message message : messages) {
            AtsdUtil.checkEntityIsEmpty(message.getEntityName());
        }
        QueryPart query = new Query("messages").path(INSERT_KEYWORD);
        return this.httpClientManager.updateData(query, RequestProcessor.post(Arrays.asList(messages)));
    }

    public boolean deleteProperties(List<DeletePropertyFilter> deletePropertyFilters) {
        Query query = new Query("properties/delete");
        return this.httpClientManager.updateData(query, RequestProcessor.post(deletePropertyFilters));
    }

    public boolean deleteProperties(DeletePropertyFilter ... deletePropertyFilters) {
        return this.deleteProperties(Arrays.asList(deletePropertyFilters));
    }

    public List<Alert> retrieveAlerts(List<String> metricNames, List<String> entityNames, List<String> ruleNames, List<Integer> severityIds, Integer minSeverityId, TimeFormat timeFormat) {
        GetAlertQuery alertQuery = new GetAlertQuery(metricNames, entityNames, ruleNames, severityIds, minSeverityId, timeFormat);
        alertQuery.setStartTime(0L);
        alertQuery.setEndTime(System.currentTimeMillis());
        return this.retrieveAlerts(alertQuery);
    }

    public List<Alert> retrieveAlerts(GetAlertQuery ... alertQueries) {
        Query query = new Query("/alerts/query");
        return this.httpClientManager.requestDataList(Alert.class, query, RequestProcessor.post(Arrays.asList(alertQueries)));
    }

    public List<AlertHistory> retrieveAlertHistory(GetAlertHistoryQuery getAlertHistoryQuery, GetAlertHistoryQuery ... getAlertHistoryQueries) {
        QueryPart query = new Query("alerts").path("history");
        return this.httpClientManager.requestDataList(AlertHistory.class, query, RequestProcessor.post(new BatchQuery<GetAlertHistoryQuery>(getAlertHistoryQuery, getAlertHistoryQueries)));
    }

    public boolean batchUpdateAlerts(BatchAlertCommand ... commands) {
        Query query = new Query("alerts");
        return this.httpClientManager.updateData(query, RequestProcessor.patch(commands));
    }

    public void sendPlainCommand(PlainCommand plainCommand) throws AtsdClientException, AtsdServerException {
        this.httpClientManager.send(plainCommand);
    }

    public BatchResponse sendBatch(Collection<PlainCommand> commands) {
        return this.sendBatch(commands, false);
    }

    public BatchResponse sendBatch(Collection<PlainCommand> commands, boolean commit) {
        QueryPart query = new Query("command");
        query = query.param("commit", commit);
        StringBuilder data = new StringBuilder();
        for (PlainCommand command : commands) {
            data.append(command.compose());
        }
        return this.httpClientManager.requestData(query, data.toString(), new BatchResponseExtractor());
    }

    public boolean canSendPlainCommand() {
        return this.httpClientManager.canSendPlainCommand();
    }

    public List<String> removeSavedPlainCommands() {
        return this.httpClientManager.removeSavedPlainCommands();
    }

    private static class BatchResponseExtractor
    implements ResponseDataExtractor<BatchResponse> {
        private BatchResponseExtractor() {
        }

        @Override
        public BatchResponse extract(Response response) {
            BatchResponse batchResponse = new BatchResponse(response.getStatusInfo());
            if (AtsdUtil.hasStatusFamily(response, Response.Status.Family.SUCCESSFUL)) {
                SendCommandResult sendCommandResult = (SendCommandResult)response.readEntity(SendCommandResult.class);
                batchResponse.setResult(sendCommandResult);
            } else {
                ServerError serverError = HttpClient.buildAndLogServerError(response);
                batchResponse.setServerError(serverError);
            }
            return batchResponse;
        }
    }

    private static class LastPreparer
    implements SeriesCommandPreparer {
        private LastPreparer() {
        }

        @Override
        public void prepare(GetSeriesQuery command) {
            command.setCache(true);
        }
    }
}

